/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.gradle.openapi.external.ui.SettingsNodeVersion1;
import org.jdom.Element;
import org.jetbrains.plugins.groovy.gradle.ui.GradleIdeaSettingsNode;

@State(name="GradleUISettings", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/gradle_config.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class GradleUISettings
implements PersistentStateComponent<Element> {
    private GradleIdeaSettingsNode rootNode = new GradleIdeaSettingsNode("root", null);
    private static final String SETTING = "setting";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    public GradleIdeaSettingsNode getRootNode() {
        return this.rootNode;
    }

    public Element getState() {
        Element e = new Element(SETTING);
        this.writeOutSetting(e, this.rootNode);
        return e;
    }

    public void loadState(Element element) {
        List<GradleIdeaSettingsNode> settingsNodes = this.readInSetting(element, null);
        if (!settingsNodes.isEmpty()) {
            this.rootNode = settingsNodes.get(0);
        }
    }

    public static GradleUISettings getInstance(Project project) {
        return (GradleUISettings)ServiceManager.getService((Project)project, GradleUISettings.class);
    }

    private void writeOutSetting(Element parentElement, GradleIdeaSettingsNode node) {
        Element element = new Element(SETTING);
        parentElement.addContent(element);
        element.setAttribute(NAME, node.getName());
        if (node.getValue() != null) {
            element.setAttribute(VALUE, node.getValue());
        }
        for (SettingsNodeVersion1 settingsNode : node.getChildNodes()) {
            this.writeOutSetting(element, (GradleIdeaSettingsNode)settingsNode);
        }
    }

    private List<GradleIdeaSettingsNode> readInSetting(Element parentElement, GradleIdeaSettingsNode parentNode) {
        ArrayList<GradleIdeaSettingsNode> nodesReadIn = new ArrayList<GradleIdeaSettingsNode>();
        for (Element element : parentElement.getChildren(SETTING)) {
            String name = element.getAttributeValue(NAME);
            GradleIdeaSettingsNode node = new GradleIdeaSettingsNode(name, parentNode);
            String value = element.getAttributeValue(VALUE);
            if (value != null) {
                node.setValue(value);
            }
            List<GradleIdeaSettingsNode> myChildren = this.readInSetting(element, node);
            node.setChildren(myChildren);
            nodesReadIn.add(node);
        }
        return nodesReadIn;
    }
}

