/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryManager {
    public abstract boolean managesLibrary(@NotNull Library var1, LibrariesContainer var2);

    @Nullable
    @Nls
    public abstract String getLibraryVersion(@NotNull Library var1, LibrariesContainer var2);

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract String getAddActionText();

    public abstract boolean isSDKHome(@NotNull VirtualFile var1);

    @NotNull
    public abstract String getSDKVersion(String var1);

    @Nullable
    public abstract Library createLibrary(@NotNull FacetEditorContext var1);

    @NotNull
    @Nls
    public abstract String getLibraryCategoryName();

    @NotNull
    @Nls
    public String getLibraryPrefix() {
        String string = StringUtil.toLowerCase((String)this.getLibraryCategoryName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/LibraryManager.getLibraryPrefix must not return null");
        }
        return string;
    }

    public boolean managesName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/LibraryManager.managesName must not be null");
        }
        return StringUtil.startsWithIgnoreCase((String)name, (String)this.getLibraryPrefix());
    }
}

