/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler.generator;

import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Chunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerBase;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.compiler.generator.GroovyToJavaGenerator;

public class GroovycStubGenerator
extends GroovyCompilerBase {
    public GroovycStubGenerator(Project project) {
        super(project);
    }

    @Override
    public void compile(CompileContext compileContext, Chunk<Module> moduleChunk, VirtualFile[] virtualFiles, TranslatingCompiler.OutputSink sink) {
        CompileScope scope = compileContext.getCompileScope();
        VirtualFile[] javaFiles = scope.getFiles((FileType)StdFileTypes.JAVA, true);
        if (javaFiles.length == 0) {
            return;
        }
        boolean hasJava = false;
        for (VirtualFile javaFile : javaFiles) {
            Module module = ModuleUtil.findModuleForFile((VirtualFile)javaFile, (Project)this.myProject);
            if (module == null || !moduleChunk.containsNode((Object)module)) continue;
            hasJava = true;
            break;
        }
        if (!hasJava) {
            return;
        }
        ExcludedEntriesConfiguration excluded = GroovyCompilerConfiguration.getExcludeConfiguration(this.myProject);
        ArrayList<VirtualFile> total = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFiles) {
            if (excluded.isExcluded(virtualFile) || virtualFile.getFileType() != GroovyFileType.GROOVY_FILE_TYPE) continue;
            total.add(virtualFile);
        }
        if (total.isEmpty()) {
            return;
        }
        super.compile(compileContext, moduleChunk, VfsUtil.toVirtualFileArray(total), sink);
    }

    @Override
    protected void compileFiles(CompileContext compileContext, Module module, List<VirtualFile> toCompile, TranslatingCompiler.OutputSink sink, boolean tests) {
        String rootPath = CompilerPaths.getGeneratedDataDirectory((Project)this.myProject) + "/groovyStubs/";
        File outDir = new File(rootPath + this.myProject.getLocationHash() + "/" + module.getName() + "/" + (tests ? "tests" : "production") + "/");
        outDir.mkdirs();
        VirtualFile tempOutput = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outDir);
        assert (tempOutput != null);
        this.cleanDirectory(tempOutput);
        ((CompileContextEx)compileContext).assignModule(tempOutput, module, tests);
        if (GroovyCompilerConfiguration.getInstance(this.myProject).isUseGroovycStubs()) {
            this.runGroovycCompiler(compileContext, module, toCompile, true, tempOutput, sink, tests);
        } else {
            GroovyToJavaGenerator generator = new GroovyToJavaGenerator(this.myProject, compileContext);
            for (VirtualFile file : toCompile) {
                String outPath = tempOutput.getPath();
                List<String> relPaths = generator.generateItems(file, tempOutput);
                ArrayList<String> fullPaths = new ArrayList<String>();
                for (String relPath : relPaths) {
                    fullPaths.add(outPath + "/" + relPath);
                }
                GroovycStubGenerator.addStubsToCompileScope(fullPaths, compileContext, module);
            }
        }
    }

    private void cleanDirectory(final VirtualFile dir) {
        new WriteCommandAction(this.myProject, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                this.deleteChildrenRecursively(dir);
            }

            private void deleteChildrenRecursively(VirtualFile dir2) throws IOException {
                for (VirtualFile child : dir2.getChildren()) {
                    if (child.isDirectory()) {
                        this.deleteChildrenRecursively(child);
                    }
                    TranslatingCompilerFilesMonitor.removeSourceInfo((VirtualFile)child);
                    try {
                        child.delete((Object)this);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
        }.execute();
    }

    @NotNull
    public String getDescription() {
        if ("Groovy to java source code generator" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/compiler/generator/GroovycStubGenerator.getDescription must not return null");
        }
        return "Groovy to java source code generator";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }
}

