/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GroovyOctalIntegerInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOctalIntegerInspection.getGroupDisplayName must not return null");
        }
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Octal integer" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOctalIntegerInspection.getDisplayName must not return null");
        }
        return "Octal integer";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Octal integer #ref #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitLiteralExpression(GrLiteral literal) {
            super.visitLiteralExpression(literal);
            String text = literal.getText();
            if (!(!text.startsWith("0") || "0".equals(text) || text.startsWith("0x") || text.startsWith("0X") || text.contains(".") || text.contains("e") || text.contains("E"))) {
                this.registerError(literal);
            }
        }
    }
}

