/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyIcons;

public class GroovyTemplatesFactory
implements FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String[] TEMPLATES = new String[]{"GroovyClass.groovy", "GroovyScript.groovy", "GroovyControllerTests.groovy"};
    private final ArrayList<String> myCustomTemplates = new ArrayList();
    public static final String GSP_TEMPLATE = "GroovyServerPage.gsp";
    @NonNls
    static final String NAME_TEMPLATE_PROPERTY = "NAME";
    static final String LOW_CASE_NAME_TEMPLATE_PROPERTY = "lowCaseName";

    public void registerCustromTemplates(String ... templates) {
        for (String template : templates) {
            this.myCustomTemplates.add(template);
        }
    }

    public static GroovyTemplatesFactory getInstance() {
        return GroovyTemplatesFactoryHolder.myInstance;
    }

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor group = new FileTemplateGroupDescriptor(GroovyBundle.message("file.template.group.title.groovy", new Object[0]), GroovyIcons.GROOVY_ICON_16x16);
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (String template : TEMPLATES) {
            group.addTemplate(new FileTemplateDescriptor(template, fileTypeManager.getFileTypeByFileName(template).getIcon()));
        }
        group.addTemplate(new FileTemplateDescriptor(GSP_TEMPLATE, fileTypeManager.getFileTypeByFileName(GSP_TEMPLATE).getIcon()));
        for (String template : GroovyTemplatesFactory.getInstance().getCustomTemplates()) {
            group.addTemplate(new FileTemplateDescriptor(template, fileTypeManager.getFileTypeByFileName(template).getIcon()));
        }
        return group;
    }

    public static PsiFile createFromTemplate(PsiDirectory directory, String name, String fileName, String templateName, String ... parameters) throws IncorrectOperationException {
        String text;
        FileTemplate template = FileTemplateManager.getInstance().getInternalTemplate(templateName);
        Properties properties = new Properties(FileTemplateManager.getInstance().getDefaultProperties());
        JavaTemplateUtil.setPackageNameAttribute((Properties)properties, (PsiDirectory)directory);
        properties.setProperty(NAME_TEMPLATE_PROPERTY, name);
        properties.setProperty(LOW_CASE_NAME_TEMPLATE_PROPERTY, name.substring(0, 1).toLowerCase() + name.substring(1));
        for (int i = 0; i < parameters.length; i += 2) {
            properties.setProperty(parameters[i], parameters[i + 1]);
        }
        try {
            text = template.getText(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load template for " + FileTemplateManager.getInstance().internalTemplateToSubject(templateName), e);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)directory.getProject());
        PsiFile file = factory.createFileFromText(fileName, text);
        return (PsiFile)directory.add((PsiElement)file);
    }

    public String[] getCustomTemplates() {
        return ArrayUtil.toStringArray(this.myCustomTemplates);
    }

    private static class GroovyTemplatesFactoryHolder {
        private static final GroovyTemplatesFactory myInstance = new GroovyTemplatesFactory();

        private GroovyTemplatesFactoryHolder() {
        }
    }
}

