/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.navigator.SelectMavenGoalDialog;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenBeforeRunTasksProvider
extends BeforeRunTaskProvider<MavenBeforeRunTask> {
    public static final Key<MavenBeforeRunTask> TASK_ID = Key.create((String)"Maven.BeforeRunTask");
    private final Project myProject;

    public MavenBeforeRunTasksProvider(Project project) {
        this.myProject = project;
    }

    public Key<MavenBeforeRunTask> getId() {
        return TASK_ID;
    }

    public String getDescription(RunConfiguration runConfiguration, MavenBeforeRunTask task) {
        Pair<MavenProject, String> projectAndGoal;
        String desc = null;
        if (task.isEnabled() && (projectAndGoal = this.getProjectAndGoalChecked(task)) != null) {
            desc = ((MavenProject)projectAndGoal.first).getDisplayName() + ":" + (String)projectAndGoal.second;
        }
        return desc == null ? TasksBundle.message("maven.tasks.before.run.empty", new Object[0]) : TasksBundle.message("maven.tasks.before.run", desc);
    }

    private Pair<MavenProject, String> getProjectAndGoalChecked(MavenBeforeRunTask task) {
        String path = task.getProjectPath();
        String goal = task.getGoal();
        if (path == null || goal == null) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return null;
        }
        MavenProject project = MavenProjectsManager.getInstance(this.myProject).findProject(file);
        if (project == null) {
            return null;
        }
        return Pair.create((Object)project, (Object)goal);
    }

    public boolean hasConfigurationButton() {
        return true;
    }

    public MavenBeforeRunTask createTask(RunConfiguration runConfiguration) {
        return new MavenBeforeRunTask();
    }

    public boolean configureTask(RunConfiguration runConfiguration, MavenBeforeRunTask task) {
        SelectMavenGoalDialog dialog = new SelectMavenGoalDialog(this.myProject, task.getProjectPath(), task.getGoal(), TasksBundle.message("maven.tasks.select.goal.title", new Object[0]));
        dialog.show();
        if (!dialog.isOK()) {
            return false;
        }
        task.setProjectPath(dialog.getSelectedProjectPath());
        task.setGoal(dialog.getSelectedGoal());
        return true;
    }

    public boolean executeTask(final DataContext context, RunConfiguration configuration, final MavenBeforeRunTask task) {
        final Semaphore targetDone = new Semaphore();
        final boolean[] result = new boolean[1];
        try {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    final Project project = (Project)PlatformDataKeys.PROJECT.getData(context);
                    final Pair projectAndGoal = MavenBeforeRunTasksProvider.this.getProjectAndGoalChecked(task);
                    if (project == null || project.isDisposed() || projectAndGoal == null) {
                        return;
                    }
                    targetDone.down();
                    new Task.Backgroundable(project, TasksBundle.message("maven.tasks.executing", new Object[0]), true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider$1$1.run must not be null");
                            }
                            try {
                                MavenRunnerParameters params = new MavenRunnerParameters(true, ((MavenProject)projectAndGoal.first).getDirectory(), Collections.singletonList(projectAndGoal.second), MavenProjectsManager.getInstance(project).getExplicitProfiles());
                                result[0] = MavenRunner.getInstance(project).runBatch(Collections.singletonList(params), null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), indicator);
                            }
                            finally {
                                targetDone.up();
                            }
                        }

                        public boolean shouldStartInBackground() {
                            return MavenRunner.getInstance(project).getSettings().isRunMavenInBackground();
                        }

                        public void processSentToBackground() {
                            MavenRunner.getInstance(project).getSettings().setRunMavenInBackground(true);
                        }
                    }.queue();
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            MavenLog.LOG.error((Throwable)e);
            return false;
        }
        targetDone.waitFor();
        return result[0];
    }
}

