/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.EditMavenPropertyDialog;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public abstract class MavenRunnerConfigurable
implements SearchableConfigurable {
    private JPanel panel;
    private JCheckBox checkBoxRunMavenInBackground;
    private JLabel labelVMParameters;
    private RawCommandLineEditor textFieldVMParameters;
    private JComboBox comboBoxChooseJDK;
    private final DefaultComboBoxModel comboboxModelChooseJdk;
    private JCheckBox checkBoxSkipTests;
    private JPanel panelForPropertiesEditor;
    private final MyPropertiesPanel propertiesPanel;
    private final Project myProject;
    private Map<String, String> myProperties;

    public MavenRunnerConfigurable(Project p, boolean isRunConfiguration) {
        this.$$$setupUI$$$();
        this.comboboxModelChooseJdk = new DefaultComboBoxModel();
        this.myProject = p;
        this.propertiesPanel = new MyPropertiesPanel();
        this.panelForPropertiesEditor.add((Component)((Object)this.propertiesPanel), "Center");
        this.textFieldVMParameters.setDialogCaption(this.labelVMParameters.getText());
        this.checkBoxRunMavenInBackground.setVisible(!isRunConfiguration);
        this.collectProperties();
    }

    private void collectProperties() {
        MavenProjectsManager s = MavenProjectsManager.getInstance(this.myProject);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (MavenProject each : s.getProjects()) {
            Properties properties = each.getProperties();
            for (Map.Entry<Object, Object> p : properties.entrySet()) {
                result.put((String)p.getKey(), (String)p.getValue());
            }
        }
        this.myProperties = result;
    }

    protected abstract MavenRunnerSettings getState();

    public JComponent createComponent() {
        return this.getRootComponent();
    }

    public boolean isModified() {
        MavenRunnerSettings s = new MavenRunnerSettings();
        this.setData(s);
        return !s.equals(this.getState());
    }

    public void apply() throws ConfigurationException {
        this.setData(this.getState());
    }

    public void reset() {
        this.getData(this.getState());
    }

    @Nls
    public String getDisplayName() {
        return RunnerBundle.message("maven.tab.runner", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.maven.runner";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public void disposeUIResources() {
    }

    private void fillComboboxJdk(MavenRunnerSettings data) {
        this.comboboxModelChooseJdk.removeAllElements();
        for (Pair<String, String> jdk : data.collectJdkNamesAndDescriptions()) {
            ComboBoxUtil.addToModel(this.comboboxModelChooseJdk, jdk.getFirst(), (String)jdk.getSecond());
        }
        this.comboBoxChooseJDK.setModel(this.comboboxModelChooseJdk);
    }

    JComponent getRootComponent() {
        return this.panel;
    }

    void getData(MavenRunnerSettings data) {
        this.checkBoxRunMavenInBackground.setSelected(data.isRunMavenInBackground());
        this.textFieldVMParameters.setText(data.getVmOptions());
        this.checkBoxSkipTests.setSelected(data.isSkipTests());
        this.fillComboboxJdk(data);
        ComboBoxUtil.select(this.comboboxModelChooseJdk, data.getJreName());
        this.propertiesPanel.setDataFromMap(data.getMavenProperties());
    }

    void setData(MavenRunnerSettings data) {
        data.setRunMavenInBackground(this.checkBoxRunMavenInBackground.isSelected());
        data.setVmOptions(this.textFieldVMParameters.getText().trim());
        data.setSkipTests(this.checkBoxSkipTests.isSelected());
        data.setJreName(ComboBoxUtil.getSelectedString(this.comboboxModelChooseJdk));
        data.setMavenProperties(this.propertiesPanel.getDataAsMap());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.panel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.checkBoxRunMavenInBackground = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("Run in background");
        jCheckBox2.setMnemonic('B');
        jCheckBox2.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.labelVMParameters = jLabel = new JLabel();
        jLabel.setText("VM Parameters");
        jLabel.setDisplayedMnemonic('V');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("JRE");
        jLabel2.setDisplayedMnemonic('J');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Properties", 0, 0, null, null));
        this.checkBoxSkipTests = jCheckBox = new JCheckBox();
        jCheckBox.setText("Skip Tests");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.panelForPropertiesEditor = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.textFieldVMParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.comboBoxChooseJDK = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class MyPropertiesTableModel
    extends AddEditRemovePanel.TableModel<Pair<String, String>> {
        private MyPropertiesTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int c) {
            return c == 0 ? "Name" : "Value";
        }

        public Object getField(Pair<String, String> o, int c) {
            return c == 0 ? (String)o.getFirst() : (String)o.getSecond();
        }
    }

    private class MyPropertiesPanel
    extends AddEditRemovePanel<Pair<String, String>> {
        public MyPropertiesPanel() {
            super((AddEditRemovePanel.TableModel)new MyPropertiesTableModel(), new ArrayList(), null);
            this.setPreferredSize(new Dimension(100, 100));
        }

        protected Pair<String, String> addItem() {
            return this.doAddOrEdit((Pair<String, String>)new Pair((Object)"", (Object)""));
        }

        protected boolean removeItem(Pair<String, String> o) {
            return true;
        }

        protected Pair<String, String> editItem(Pair<String, String> o) {
            return this.doAddOrEdit(o);
        }

        private Pair<String, String> doAddOrEdit(Pair<String, String> o) {
            EditMavenPropertyDialog d = new EditMavenPropertyDialog(MavenRunnerConfigurable.this.myProject, o, MavenRunnerConfigurable.this.myProperties);
            d.show();
            if (!d.isOK()) {
                return null;
            }
            return d.getValue();
        }

        public Map<String, String> getDataAsMap() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Pair p : this.getData()) {
                result.put((String)p.getFirst(), (String)p.getSecond());
            }
            return result;
        }

        public void setDataFromMap(Map<String, String> map) {
            ArrayList<Pair> result = new ArrayList<Pair>();
            for (Map.Entry<String, String> e : map.entrySet()) {
                result.add(new Pair((Object)e.getKey(), (Object)e.getValue()));
            }
            this.setData(result);
        }
    }
}

