/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.embedder;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Settings;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.CustomLoggerManager;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.embedder.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEmbedderFactory {
    private static final String PROP_MAVEN_HOME = "maven.home";
    private static final String PROP_USER_HOME = "user.home";
    private static final String ENV_M2_HOME = "M2_HOME";
    private static final String M2_DIR = "m2";
    private static final String BIN_DIR = "bin";
    private static final String DOT_M2_DIR = ".m2";
    private static final String CONF_DIR = "conf";
    private static final String LIB_DIR = "lib";
    private static final String M2_CONF_FILE = "m2.conf";
    private static final String REPOSITORY_DIR = "repository";
    private static final List<String> PHASES = Arrays.asList("clean", "validate", "generate-sources", "process-sources", "generate-resources", "process-resources", "compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "site", "deploy");
    private static final List<String> BASIC_PHASES = Arrays.asList("clean", "validate", "compile", "test", "package", "install", "deploy", "site");
    private static volatile Properties mySystemPropertiesCache;
    private static final String SUPER_POM_PATH = "org/apache/maven/project/pom-4.0.0.xml";

    @Nullable
    public static File resolveMavenHomeDirectory(@Nullable String overrideMavenHome) {
        File underUserHome;
        File homeFromEnv;
        if (!StringUtil.isEmptyOrSpaces((String)overrideMavenHome)) {
            return new File(overrideMavenHome);
        }
        String m2home = System.getenv(ENV_M2_HOME);
        if (!StringUtil.isEmptyOrSpaces((String)m2home) && MavenEmbedderFactory.isValidMavenHome(homeFromEnv = new File(m2home))) {
            return homeFromEnv;
        }
        String userHome = System.getProperty(PROP_USER_HOME);
        if (!StringUtil.isEmptyOrSpaces((String)userHome) && MavenEmbedderFactory.isValidMavenHome(underUserHome = new File(userHome, M2_DIR))) {
            return underUserHome;
        }
        return null;
    }

    public static boolean isValidMavenHome(File home) {
        return MavenEmbedderFactory.getMavenConfFile(home).exists();
    }

    public static File getMavenConfFile(File mavenHome) {
        return new File(new File(mavenHome, BIN_DIR), M2_CONF_FILE);
    }

    @Nullable
    public static File resolveGlobalSettingsFile(@Nullable String overrideMavenHome) {
        File directory = MavenEmbedderFactory.resolveMavenHomeDirectory(overrideMavenHome);
        if (directory == null) {
            return null;
        }
        return new File(new File(directory, CONF_DIR), "settings.xml");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile resolveSuperPomFile(@Nullable String overrideMavenHome) {
        VirtualFile virtualFile;
        VirtualFile result = MavenEmbedderFactory.doResolveSuperPomFile(overrideMavenHome);
        if (result == null) {
            URL resource = MavenEmbedderFactory.class.getResource("/org/apache/maven/project/pom-4.0.0.xml");
            virtualFile = VfsUtil.findFileByURL((URL)resource);
            if (virtualFile == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.resolveSuperPomFile must not return null");
            return virtualFile;
        }
        virtualFile = result;
        if (virtualFile != null) return virtualFile;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.resolveSuperPomFile must not return null");
    }

    @Nullable
    private static VirtualFile doResolveSuperPomFile(String overrideMavenHome) {
        File lib = MavenEmbedderFactory.resolveMavenLib(overrideMavenHome);
        if (lib == null) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(lib);
        if (file == null) {
            return null;
        }
        VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        if (root == null) {
            return null;
        }
        return root.findFileByRelativePath(SUPER_POM_PATH);
    }

    private static File resolveMavenLib(String overrideMavenHome) {
        File directory = MavenEmbedderFactory.resolveMavenHomeDirectory(overrideMavenHome);
        if (directory == null) {
            return null;
        }
        File libs = new File(directory, LIB_DIR);
        File[] files = libs.listFiles();
        if (files != null) {
            Pattern pattern = Pattern.compile("maven-\\d+\\.\\d+\\.\\d+-uber\\.jar");
            for (File each : files) {
                if (!pattern.matcher(each.getName()).matches()) continue;
                return each;
            }
        }
        return null;
    }

    @Nullable
    public static File resolveUserSettingsFile(@Nullable String overrideSettingsFile) {
        if (!StringUtil.isEmptyOrSpaces((String)overrideSettingsFile)) {
            return new File(overrideSettingsFile);
        }
        String userHome = System.getProperty(PROP_USER_HOME);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            return null;
        }
        return new File(new File(userHome, DOT_M2_DIR), "settings.xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File resolveLocalRepository(@Nullable String mavenHome, @Nullable String userSettings, @Nullable String override) {
        File file;
        File file2;
        File result = MavenEmbedderFactory.doResolveLocalRepository(mavenHome, userSettings, override);
        try {
            file2 = result.getCanonicalFile();
        }
        catch (IOException e) {
            file = result;
            if (file == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.resolveLocalRepository must not return null");
            return file;
        }
        file = file2;
        if (file2 == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.resolveLocalRepository must not return null");
        return file;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static File doResolveLocalRepository(String mavenHome, String userSettings, String override) {
        String fromGlobalSettings;
        String fromUserSettings;
        File file;
        if (!StringUtil.isEmpty((String)override)) {
            file = new File(override);
            if (file == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.doResolveLocalRepository must not return null");
            return file;
        }
        File userSettingsFile = MavenEmbedderFactory.resolveUserSettingsFile(userSettings);
        if (userSettingsFile != null && !StringUtil.isEmpty((String)(fromUserSettings = MavenEmbedderFactory.getRepositoryFromSettings(userSettingsFile)))) {
            file = new File(fromUserSettings);
            if (file == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.doResolveLocalRepository must not return null");
            return file;
        }
        File globalSettingsFile = MavenEmbedderFactory.resolveGlobalSettingsFile(mavenHome);
        if (globalSettingsFile != null && !StringUtil.isEmpty((String)(fromGlobalSettings = MavenEmbedderFactory.getRepositoryFromSettings(globalSettingsFile)))) {
            file = new File(fromGlobalSettings);
            if (file == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.doResolveLocalRepository must not return null");
            return file;
        }
        file = new File(new File(System.getProperty(PROP_USER_HOME), DOT_M2_DIR), REPOSITORY_DIR);
        if (file != null) return file;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/embedder/MavenEmbedderFactory.doResolveLocalRepository must not return null");
    }

    @Nullable
    private static String getRepositoryFromSettings(File file) {
        try {
            byte[] bytes = FileUtil.loadFileBytes((File)file);
            return MavenEmbedderFactory.expandProperties(MavenJDOMUtil.findChildValueByPath(MavenJDOMUtil.read(bytes, null), "localRepository", null));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String expandProperties(String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return text;
        }
        Properties props = MavenEmbedderFactory.collectSystemProperties();
        for (Map.Entry<Object, Object> each : props.entrySet()) {
            text = text.replace("${" + each.getKey() + "}", (CharSequence)each.getValue());
        }
        return text;
    }

    public static List<String> getBasicPhasesList() {
        return BASIC_PHASES;
    }

    public static List<String> getPhasesList() {
        return PHASES;
    }

    public static MavenEmbedderWrapper createEmbedder(MavenGeneralSettings generalSettings) {
        DefaultPlexusContainer container;
        try {
            container = new DefaultPlexusContainer();
        }
        catch (RuntimeException e) {
            String s = "Cannot initialize Maven. Please make sure that your IDEA installation is correct and has no old libraries.";
            throw new RuntimeException(s, e);
        }
        container.setClassWorld(new ClassWorld("plexus.core", generalSettings.getClass().getClassLoader()));
        CustomLoggerManager loggerManager = new CustomLoggerManager(generalSettings.getLoggingLevel());
        container.setLoggerManager((LoggerManager)loggerManager);
        try {
            container.initialize();
            container.start();
        }
        catch (PlexusContainerException e) {
            MavenLog.LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        File mavenHome = generalSettings.getEffectiveMavenHome();
        if (mavenHome != null) {
            System.setProperty(PROP_MAVEN_HOME, mavenHome.getPath());
        }
        Settings settings = MavenEmbedderFactory.buildSettings((PlexusContainer)container, generalSettings);
        return new MavenEmbedderWrapper(container, settings, loggerManager.getLogger(), generalSettings);
    }

    private static Settings buildSettings(PlexusContainer container, MavenGeneralSettings generalSettings) {
        File localRepository;
        File file = generalSettings.getEffectiveGlobalSettingsIoFile();
        if (file != null) {
            System.setProperty("org.apache.maven.global-settings", file.getPath());
        }
        Settings settings = null;
        try {
            MavenSettingsBuilder builder = (MavenSettingsBuilder)container.lookup(MavenSettingsBuilder.ROLE);
            File userSettingsFile = generalSettings.getEffectiveUserSettingsIoFile();
            if (userSettingsFile != null && userSettingsFile.exists() && !userSettingsFile.isDirectory()) {
                settings = builder.buildSettings(userSettingsFile, false);
            }
            if (settings == null) {
                settings = builder.buildSettings();
            }
        }
        catch (ComponentLookupException e) {
            MavenLog.LOG.error((Throwable)e);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        catch (XmlPullParserException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        if (settings == null) {
            settings = new Settings();
        }
        if ((localRepository = generalSettings.getEffectiveLocalRepository()) != null) {
            settings.setLocalRepository(localRepository.getPath());
        }
        settings.setOffline(generalSettings.isWorkOffline());
        settings.setInteractiveMode(false);
        settings.setUsePluginRegistry(generalSettings.isUsePluginRegistry());
        RuntimeInfo runtimeInfo = new RuntimeInfo(settings);
        runtimeInfo.setPluginUpdateOverride(Boolean.valueOf(generalSettings.getPluginUpdatePolicy() == MavenExecutionOptions.PluginUpdatePolicy.UPDATE));
        settings.setRuntimeInfo(runtimeInfo);
        return settings;
    }

    public static Properties collectSystemProperties() {
        if (mySystemPropertiesCache == null) {
            Properties result = new Properties();
            result.putAll((Map<?, ?>)MavenUtil.getSystemProperties());
            Properties envVars = MavenUtil.getEnvProperties();
            for (Map.Entry<Object, Object> each : envVars.entrySet()) {
                result.setProperty("env." + each.getKey().toString(), each.getValue().toString());
            }
            mySystemPropertiesCache = result;
        }
        return mySystemPropertiesCache;
    }

    public static void resetSystemPropertiesCacheInTests() {
        mySystemPropertiesCache = null;
    }
}

