/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenParentRelativePathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        VirtualFile f = context.getFile().getVirtualFile().getParent().findFileByRelativePath(s);
        if (f == null) {
            return null;
        }
        if (f.isDirectory()) {
            f = f.findFileByRelativePath("pom.xml");
        }
        if (f == null) {
            return null;
        }
        return PsiManager.getInstance((Project)context.getXmlElement().getProject()).findFile(f);
    }

    public String toString(@Nullable PsiFile f, ConvertContext context) {
        if (f == null) {
            return null;
        }
        PsiFile currentPsiFile = context.getFile().getOriginalFile();
        if (currentPsiFile == null) {
            currentPsiFile = context.getFile();
        }
        VirtualFile currentFile = currentPsiFile.getVirtualFile();
        return MavenDomUtil.calcRelativePath(currentFile.getParent(), f.getVirtualFile());
    }

    @NotNull
    public Collection<PsiFile> getVariants(ConvertContext context) {
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        PsiFile currentFile = context.getFile().getOriginalFile();
        for (DomFileElement<MavenDomProjectModel> each : MavenDomUtil.collectProjectModels(context.getFile().getProject())) {
            XmlFile file = each.getOriginalFile();
            if (file == currentFile) continue;
            result.add((PsiFile)file);
        }
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter.getVariants must not return null");
        }
        return arrayList;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return (LocalQuickFix[])ArrayUtil.append((Object[])super.getQuickFixes(context), (Object)new RelativePathFix(context));
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = this.createReferences(element, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter.createReferences must not be null");
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(psiElement, soft, new PathReferenceProvider[0]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    private class RelativePathFix
    implements LocalQuickFix {
        private final ConvertContext myContext;

        public RelativePathFix(ConvertContext context) {
            this.myContext = context;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.parent.path", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/converters/MavenParentRelativePathConverter$RelativePathFix.applyFix must not be null");
            }
            GenericDomValue el = (GenericDomValue)this.myContext.getInvocationElement();
            MavenId id = MavenArtifactCoordinatesHelper.getId(this.myContext);
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            MavenProject parentFile = manager.findProject(id);
            if (parentFile != null) {
                VirtualFile currentFile = this.myContext.getFile().getVirtualFile();
                el.setStringValue(MavenDomUtil.calcRelativePath(currentFile.getParent(), parentFile.getFile()));
            }
        }
    }
}

