/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringLiteralReference
implements PsiReference {
    protected final PsiLiteralExpression myValue;

    public StringLiteralReference(PsiLiteralExpression value) {
        this.myValue = value;
    }

    public PsiElement getElement() {
        return this.myValue;
    }

    public TextRange getRangeInElement() {
        return ElementManipulators.getValueTextRange((PsiElement)this.myValue);
    }

    public String getCanonicalText() {
        return this.myValue.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myValue;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/util/StringLiteralReference.bindToElement must not be null");
        }
        return this.myValue;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @Nullable
    protected String getValue() {
        return (String)this.myValue.getValue();
    }
}

