/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectorUtils {
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            if (o1.intersects(o2)) {
                return 0;
            }
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };

    private InjectorUtils() {
    }

    public static void addPlaceSafe(MultiHostRegistrar registrar, String prefix, String suffix, PsiLanguageInjectionHost host, TextRange textRange) {
        registrar.addPlace(prefix, suffix, host, textRange);
    }

    public static String getUnescapedText(PsiElement host, String text) {
        if (host instanceof PsiLiteralExpression) {
            return StringUtil.unescapeStringCharacters((String)text);
        }
        if (host instanceof XmlElement) {
            return XmlUtil.unescape((String)text);
        }
        return text;
    }

    public static void adjustPrefixAndSuffix(String text, StringBuilder prefix, StringBuilder suffix) {
        if (prefix.length() > 0) {
            if (!InjectorUtils.endsWithSpace(prefix) && !InjectorUtils.startsWithSpace(text)) {
                prefix.append(" ");
            } else if (InjectorUtils.endsWithSpace(prefix) && InjectorUtils.startsWithSpace(text)) {
                InjectorUtils.trim(prefix);
            }
        }
        if (suffix.length() > 0) {
            if (text.length() == 0) {
                InjectorUtils.trim(suffix);
            } else if (!InjectorUtils.startsWithSpace(suffix) && !InjectorUtils.endsWithSpace(text)) {
                suffix.insert(0, " ");
            } else if (InjectorUtils.startsWithSpace(suffix) && InjectorUtils.endsWithSpace(text)) {
                InjectorUtils.trim(suffix);
            }
        }
    }

    public static void trim(StringBuilder string) {
        while (InjectorUtils.startsWithSpace(string)) {
            string.deleteCharAt(0);
        }
        while (InjectorUtils.endsWithSpace(string)) {
            string.deleteCharAt(string.length() - 1);
        }
    }

    public static boolean startsWithSpace(CharSequence sequence) {
        int length = sequence.length();
        return length > 0 && sequence.charAt(0) <= ' ';
    }

    public static boolean endsWithSpace(CharSequence sequence) {
        int length = sequence.length();
        return length > 0 && sequence.charAt(length - 1) <= ' ';
    }

    public static void registerInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, PsiFile containingFile, MultiHostRegistrar registrar) {
        if (language == null) {
            return;
        }
        boolean injectionStarted = false;
        for (Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> trinity : list) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)trinity.first;
            if (host.getContainingFile() != containingFile) continue;
            TextRange textRange = (TextRange)trinity.third;
            InjectedLanguage injectedLanguage = (InjectedLanguage)trinity.second;
            if (!injectionStarted) {
                registrar.startInjecting(language);
                injectionStarted = true;
            }
            if (injectedLanguage.isDynamic()) {
                StringBuilder prefix = new StringBuilder(injectedLanguage.getPrefix());
                StringBuilder suffix = new StringBuilder(injectedLanguage.getSuffix());
                InjectorUtils.adjustPrefixAndSuffix(InjectorUtils.getUnescapedText((PsiElement)host, textRange.substring(host.getText())), prefix, suffix);
                InjectorUtils.addPlaceSafe(registrar, prefix.toString(), suffix.toString(), host, textRange);
                continue;
            }
            InjectorUtils.addPlaceSafe(registrar, injectedLanguage.getPrefix(), injectedLanguage.getSuffix(), host, textRange);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
    }

    @NotNull
    public static Set<String> getActiveInjectionSupportIds() {
        Set set = ContainerUtil.map2Set((Object[])InjectorUtils.getActiveInjectionSupports(), (Function)new NotNullFunction<LanguageInjectionSupport, String>(){

            @NotNull
            public String fun(LanguageInjectionSupport support) {
                String string = support.getId();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectorUtils$2.fun must not return null");
                }
                return string;
            }
        });
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/InjectorUtils.getActiveInjectionSupportIds must not return null");
        }
        return set;
    }

    public static LanguageInjectionSupport[] getActiveInjectionSupports() {
        return (LanguageInjectionSupport[])Extensions.getExtensions(LanguageInjectionSupport.EP_NAME);
    }

    @Nullable
    public static LanguageInjectionSupport findInjectionSupport(final String id) {
        return (LanguageInjectionSupport)ContainerUtil.find((Object[])InjectorUtils.getActiveInjectionSupports(), (Condition)new Condition<LanguageInjectionSupport>(){

            public boolean value(LanguageInjectionSupport support) {
                return support.getId().equals(id);
            }
        });
    }
}

