/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Tag(value="dictionary")
public class DictionaryState
implements PersistentStateComponent<DictionaryState> {
    public static final String NAME_ATTRIBUTE = "name";
    @Tag(value="words")
    @AbstractCollection(surroundWithTag=false, elementTag="w", elementValueAttribute="")
    public Set<String> words;
    @Attribute(value="name")
    public String name;
    @Transient
    private EditableDictionary dictionary;

    public DictionaryState() {
        this.words = new HashSet<String>();
    }

    public DictionaryState(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/state/DictionaryState.<init> must not be null");
        }
        this.words = new HashSet<String>();
        this.setDictionary(dictionary);
    }

    @Transient
    public void setDictionary(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/state/DictionaryState.setDictionary must not be null");
        }
        this.dictionary = dictionary;
        this.name = dictionary.getName();
        this.synchronizeWords();
    }

    @Transient
    public EditableDictionary getDictionary() {
        return this.dictionary;
    }

    public DictionaryState getState() {
        this.synchronizeWords();
        return this;
    }

    private void synchronizeWords() {
        if (this.dictionary != null) {
            HashSet<String> words = new HashSet<String>();
            words.addAll(this.dictionary.getWords());
            this.words = words;
        }
    }

    public void loadState(DictionaryState state) {
        if (state != null && state.name != null) {
            this.name = state.name;
            this.words = state.words;
        }
        this.retrieveDictionary();
    }

    private void retrieveDictionary() {
        assert (this.name != null);
        this.dictionary = new UserDictionary(this.name);
        this.dictionary.addToDictionary(this.words);
    }

    public String toString() {
        return "DictionaryState{dictionary=" + this.dictionary + '}';
    }
}

