/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;
    private final int myLine;
    private final int myOffset;

    private XSourcePositionImpl(@NotNull VirtualFile file, int line, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XSourcePositionImpl.<init> must not be null");
        }
        this.myFile = file;
        this.myLine = line;
        this.myOffset = offset;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XSourcePositionImpl.getFile must not return null");
        }
        return virtualFile;
    }

    @Nullable
    public static XSourcePositionImpl createByOffset(@Nullable VirtualFile file, int offset) {
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int line = offset < document.getTextLength() ? document.getLineNumber(offset) : -1;
        return new XSourcePositionImpl(file, line, offset);
    }

    @Nullable
    public static XSourcePositionImpl create(@Nullable VirtualFile file, int line) {
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        if (line < 0) {
            line = 0;
        }
        int offset = line < document.getLineCount() ? document.getLineStartOffset(line) : -1;
        return new XSourcePositionImpl(file, line, offset);
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XSourcePositionImpl.createNavigatable must not be null");
        }
        OpenFileDescriptor openFileDescriptor = this.myOffset != -1 ? new OpenFileDescriptor(project, this.myFile, this.myOffset) : new OpenFileDescriptor(project, this.myFile, this.getLine(), 0);
        if (openFileDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XSourcePositionImpl.createNavigatable must not return null");
        }
        return openFileDescriptor;
    }
}

