/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import org.jetbrains.annotations.NotNull;

class DomElementResolveProblemDescriptorImpl
extends DomElementProblemDescriptorImpl
implements DomElementResolveProblemDescriptor {
    @NotNull
    private final PsiReference myReference;

    public DomElementResolveProblemDescriptorImpl(@NotNull GenericDomValue domElement, @NotNull PsiReference reference, LocalQuickFix ... quickFixes) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.<init> must not be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.<init> must not be null");
        }
        super((DomElement)domElement, XmlHighlightVisitor.getErrorDescription(reference), HighlightSeverity.ERROR, quickFixes);
        this.myReference = reference;
    }

    @NotNull
    public PsiReference getPsiReference() {
        PsiReference psiReference = this.myReference;
        if (psiReference == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.getPsiReference must not return null");
        }
        return psiReference;
    }

    @NotNull
    public GenericDomValue getDomElement() {
        GenericDomValue genericDomValue = (GenericDomValue)super.getDomElement();
        if (genericDomValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.getDomElement must not return null");
        }
        return genericDomValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        Pair pair;
        PsiReference reference = this.myReference;
        PsiElement element = reference.getElement();
        if (element instanceof XmlAttributeValue && element.getTextLength() == 0) {
            pair = NO_PROBLEM;
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.computeProblemRange must not return null");
            return pair;
        }
        TextRange referenceRange = reference.getRangeInElement();
        if (referenceRange.isEmpty()) {
            pair = element instanceof XmlAttributeValue ? Pair.create((Object)TextRange.from((int)(referenceRange.getStartOffset() - 1), (int)2), (Object)element) : Pair.create((Object)TextRange.from((int)referenceRange.getStartOffset(), (int)1), (Object)element);
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.computeProblemRange must not return null");
            return pair;
        }
        pair = Pair.create((Object)referenceRange, (Object)element);
        if (pair != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomElementResolveProblemDescriptorImpl.computeProblemRange must not return null");
    }
}

