/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public abstract class ChangesTrackingTableView<T>
extends TableView<T> {
    private DocumentAdapter myMessageUpdater;

    protected abstract void onTextChanged(int var1, int var2, String var3);

    protected abstract void onEditingStopped();

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = super.getCellEditor(row, column);
        if (column != 0 || editor instanceof DefaultCellEditor) {
            // empty if block
        }
        return editor;
    }

    public boolean editCellAt(final int row, final int column, EventObject e) {
        if (super.editCellAt(row, column, e)) {
            assert (this.myMessageUpdater == null);
            final JTextField textField = this.getEditorComponent() instanceof CellEditorComponentWithBrowseButton ? (JTextField)((CellEditorComponentWithBrowseButton)this.editorComp).getChildComponent() : (JTextField)this.getEditorComponent();
            this.myMessageUpdater = new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ChangesTrackingTableView.this.onTextChanged(row, column, textField.getText());
                }
            };
            textField.getDocument().addDocumentListener((DocumentListener)this.myMessageUpdater);
            return true;
        }
        return false;
    }

    public void removeEditor() {
        if (this.myMessageUpdater != null) {
            JTextField textField = this.getEditorComponent() instanceof CellEditorComponentWithBrowseButton ? (JTextField)((CellEditorComponentWithBrowseButton)this.editorComp).getChildComponent() : (JTextField)this.getEditorComponent();
            textField.getDocument().removeDocumentListener((DocumentListener)this.myMessageUpdater);
            this.myMessageUpdater = null;
        }
        this.onEditingStopped();
        super.removeEditor();
    }
}

