/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.editor.Document;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.ID;
import java.util.Map;

public abstract class PerIndexDocumentMap<T> {
    private final Map<Document, Map<ID, T>> myVersions = new ConcurrentFactoryMap<Document, Map<ID, T>>(){

        protected Map<ID, T> create(final Document document) {
            return new ConcurrentFactoryMap<ID, T>(){

                protected T create(ID key) {
                    return PerIndexDocumentMap.this.createDefault(document);
                }
            };
        }
    };

    public T get(Document document, ID indexId) {
        return this.myVersions.get(document).get(indexId);
    }

    public void put(Document document, ID indexId, T value) {
        this.myVersions.get(document).put(indexId, value);
    }

    public synchronized T getAndSet(Document document, ID indexId, T value) {
        T old = this.get(document, indexId);
        this.put(document, indexId, value);
        return old;
    }

    public void clear() {
        this.myVersions.clear();
    }

    protected abstract T createDefault(Document var1);
}

