/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MethodGroupingRule
implements UsageGroupingRule {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.impl.rules.MethodGroupingRule");

    public UsageGroup groupUsage(Usage usage) {
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElement psiElement = ((PsiElementUsage)usage).getElement();
        if (psiElement.getContainingFile() instanceof PsiJavaFile) {
            PsiElement containingMethod = psiElement;
            while ((containingMethod = PsiTreeUtil.getParentOfType((PsiElement)containingMethod, PsiMethod.class, (boolean)true)) != null && ((PsiMethod)containingMethod).getContainingClass().getQualifiedName() == null) {
            }
            if (containingMethod != null) {
                return new MethodUsageGroup((PsiMethod)containingMethod);
            }
        }
        return null;
    }

    private static class MethodUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final SmartPsiElementPointer<PsiMethod> myMethodPointer;
        private final String myName;
        private Icon myIcon;

        public MethodUsageGroup(PsiMethod psiMethod) {
            this.myName = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            this.myMethodPointer = SmartPointerManager.getInstance((Project)psiMethod.getProject()).createLazyPointer((PsiElement)psiMethod);
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myIcon = MethodUsageGroup.getIconImpl(this.getMethod());
            }
        }

        private static Icon getIconImpl(PsiMethod psiMethod) {
            return psiMethod.getIcon(3);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodUsageGroup)) {
                return false;
            }
            MethodUsageGroup group = (MethodUsageGroup)object;
            if (this.isValid() && group.isValid()) {
                return this.getMethod().getManager().areElementsEquivalent((PsiElement)this.getMethod(), (PsiElement)group.getMethod());
            }
            return Comparing.equal((String)this.myName, (String)((MethodUsageGroup)object).myName);
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        private PsiMethod getMethod() {
            return (PsiMethod)this.myMethodPointer.getElement();
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/MethodGroupingRule$MethodUsageGroup.getText must not return null");
            }
            return string;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? this.getMethod().getFileStatus() : null;
        }

        public boolean isValid() {
            PsiMethod method = this.getMethod();
            return method != null && method.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getMethod().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(UsageGroup usageGroup) {
            if (!(usageGroup instanceof MethodUsageGroup)) {
                LOG.error("MethodUsageGroup expected but " + usageGroup.getClass() + " found");
            }
            MethodUsageGroup other = (MethodUsageGroup)usageGroup;
            PsiMethod myMethod = (PsiMethod)this.myMethodPointer.getElement();
            PsiMethod otherMethod = (PsiMethod)other.myMethodPointer.getElement();
            if (myMethod != null && otherMethod != null && myMethod != otherMethod && !UsageViewSettings.getInstance().IS_SORT_MEMBERS_ALPHABETICALLY) {
                return myMethod.getTextOffset() < otherMethod.getTextOffset() ? -1 : 1;
            }
            return this.myName.compareTo(other.myName);
        }

        public void calcData(DataKey key, DataSink sink) {
            PsiMethod method;
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.PSI_ELEMENT == key) {
                sink.put(LangDataKeys.PSI_ELEMENT, (Object)this.getMethod());
            }
            if (UsageView.USAGE_INFO_KEY == key && (method = this.getMethod()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)method));
            }
        }
    }
}

