/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.content.impl.ContentManagerImpl");
    private ContentUI myUI;
    private ArrayList<Content> myContents;
    private EventListenerList myListeners;
    private List<Content> mySelection = new ArrayList<Content>();
    private final boolean myCanCloseContents;
    private MyContentComponent myContentComponent;
    private MyFocusProxy myFocusProxy;
    private JPanel myComponent;
    private final Set<Content> myContentWithChangedComponent = new HashSet<Content>();
    private boolean myDisposed;
    private final Project myProject;

    public ContentManagerImpl(ContentUI contentUI, boolean canCloseContents, Project project) {
        this.myProject = project;
        this.myCanCloseContents = canCloseContents;
        this.myContents = new ArrayList();
        this.myListeners = new EventListenerList();
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)project, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myFocusProxy = new MyFocusProxy();
            this.myContentComponent = new MyContentComponent();
            this.myContentComponent.setContent(this.myUI.getComponent());
            this.myContentComponent.setFocusCycleRoot(true);
            this.myComponent.add((Component)((Object)this.myFocusProxy), "North");
            this.myComponent.add((Component)((Object)this.myContentComponent), "Center");
        }
        return this.myComponent;
    }

    public void addContent(@NotNull Content content, int order) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addContent must not be null");
        }
        this.addContent(content, null, order);
    }

    public void addContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addContent must not be null");
        }
        this.addContent(content, null, -1);
    }

    public void addContent(@NotNull Content content, Object constraints) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addContent must not be null");
        }
        this.addContent(content, constraints, -1);
    }

    private void addContent(@NotNull Content content, Object constraints, int index) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addContent must not be null");
        }
        if (this.myContents.contains(content)) {
            return;
        }
        ((ContentImpl)content).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content);
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content, insertIndex, ContentManagerEvent.ContentOperation.add);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content);
            } else {
                this.addSelectedContent(content);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content);
    }

    public boolean removeContent(@NotNull Content content, boolean dispose) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.removeContent must not be null");
        }
        return this.removeContent(content, true, dispose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeContent(Content content, boolean trackSelection, boolean dispose) {
        int indexToBeRemoved = this.getIndexOfContent(content);
        if (indexToBeRemoved == -1) {
            return false;
        }
        try {
            int selectedIndex;
            Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
            int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
            if (!this.fireContentRemoveQuery(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.undefined)) {
                boolean bl = false;
                return bl;
            }
            if (!content.isValid()) {
                boolean bl = false;
                return bl;
            }
            boolean wasSelected = this.isSelected(content);
            if (wasSelected) {
                this.removeFromSelection(content);
            }
            int indexToSelect = -1;
            if (wasSelected) {
                int i = indexToBeRemoved - 1;
                if (i >= 0) {
                    indexToSelect = i;
                } else if (this.getContentCount() > 1) {
                    indexToSelect = 0;
                }
            } else if (selectedIndex > indexToBeRemoved) {
                indexToSelect = selectedIndex - 1;
            }
            this.myContents.remove(content);
            content.removePropertyChangeListener((PropertyChangeListener)this);
            int newSize = this.myContents.size();
            if (newSize > 0 && trackSelection) {
                Content toSelect;
                if (indexToSelect > -1 && !this.isSelected(toSelect = this.myContents.get(indexToSelect))) {
                    if (this.myUI.isSingleSelection()) {
                        this.setSelectedContent(toSelect);
                    } else {
                        this.addSelectedContent(toSelect);
                    }
                }
            } else {
                this.mySelection.clear();
            }
            this.fireContentRemoved(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.remove);
            ((ContentImpl)content).setManager(null);
            if (dispose) {
                Disposer.dispose((Disposable)content);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            this.removeContent(content, dispose);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        Content[] contentArray = this.myContents.toArray(new Content[this.myContents.size()]);
        if (contentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/content/impl/ContentManagerImpl.getContents must not return null");
        }
        return contentArray;
    }

    public Content findContent(String displayName) {
        for (Content content : this.myContents) {
            if (!content.getDisplayName().equals(displayName)) continue;
            return content;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(JComponent component) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
            return content;
        }
        return null;
    }

    public int getIndexOfContent(Content content) {
        return this.myContents.indexOf(content);
    }

    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.getAdditionalPopupActions must not be null");
        }
        return null;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content : this.myContents) {
            if (!content.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addSelectedContent must not be null");
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, false)) {
            return;
        }
        if (this.getIndexOfContent(content) == -1) {
            throw new IllegalArgumentException("content not found: " + content);
        }
        if (!this.isSelected(content)) {
            this.mySelection.add(content);
            this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content, implicit)) {
            return false;
        }
        boolean result = !this.isSelected(content) || this.myContentWithChangedComponent.contains(content);
        this.myContentWithChangedComponent.remove(content);
        return result;
    }

    public void removeFromSelection(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.removeFromSelection must not be null");
        }
        if (!this.isSelected(content)) {
            return;
        }
        this.mySelection.remove(content);
        this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.isSelected must not be null");
        }
        return this.mySelection.contains(content);
    }

    @NotNull
    public Content[] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[this.mySelection.size()]);
        if (contentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/content/impl/ContentManagerImpl.getSelectedContents must not return null");
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContent must not be null");
        }
        this.setSelectedContentCB(content, requestFocus);
    }

    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContentCB must not be null");
        }
        return this.setSelectedContentCB(content, requestFocus, true);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContent must not be null");
        }
        this.setSelectedContentCB(content, requestFocus, forcedFocus);
    }

    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContentCB must not be null");
        }
        return this.setSelectedContent(content, requestFocus, forcedFocus, false);
    }

    public ActionCallback setSelectedContent(final @NotNull Content content, final boolean requestFocus, final boolean forcedFocus, boolean implicit) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContent must not be null");
        }
        if (this.isSelected(content) && requestFocus) {
            return this.requestFocus(content, forcedFocus);
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, implicit)) {
            return new ActionCallback.Rejected();
        }
        if (!this.myContents.contains(content)) {
            throw new IllegalArgumentException("Cannot find content:" + content.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        Runnable selection = new Runnable(){

            @Override
            public void run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content) == -1) {
                    return;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content);
                if (requestFocus) {
                    ContentManagerImpl.this.requestFocus(content, forcedFocus);
                }
            }
        };
        if (focused || requestFocus) {
            return this.getFocusManager().requestFocus((Component)((Object)this.myFocusProxy), true).doWhenProcessed(selection);
        }
        selection.run();
        return new ActionCallback.Done();
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((JComponent)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    public ActionCallback setSelectedContentCB(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContentCB must not be null");
        }
        return this.setSelectedContentCB(content, false);
    }

    public void setSelectedContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.setSelectedContent must not be null");
        }
        this.setSelectedContentCB(content);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addContentManagerListener must not be null");
        }
        this.myListeners.add(ContentManagerListener.class, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.removeContentManagerListener must not be null");
        }
        this.myListeners.remove(ContentManagerListener.class, l);
    }

    private void fireContentAdded(Content content, int newIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, newIndex, operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.contentAdded(event);
        }
    }

    private void fireContentRemoved(Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.contentRemoved(event);
        }
    }

    private void fireSelectionChanged(Content content, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, this.myContents.indexOf(content), operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.selectionChanged(event);
        }
    }

    private boolean fireContentRemoveQuery(Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerListener[] listeners;
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener : listeners = (ContentManagerListener[])this.myListeners.getListeners(ContentManagerListener.class)) {
            listener.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    public ActionCallback requestFocus(Content content, boolean forced) {
        Content toSelect;
        Content content2 = toSelect = content == null ? this.getSelectedContent() : content;
        if (toSelect == null) {
            return new ActionCallback.Rejected();
        }
        assert (this.myContents.contains(toSelect));
        return this.getFocusManager().requestFocus(new FocusCommand(content, toSelect.getPreferredFocusableComponent()){

            public ActionCallback run() {
                return ContentManagerImpl.doRequestFocus(toSelect);
            }
        }, forced);
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    private static ActionCallback doRequestFocus(Content toSelect) {
        JComponent toFocus = ContentManagerImpl.computeWillFocusComponent(toSelect);
        if (toFocus != null) {
            toFocus.requestFocus();
        }
        return new ActionCallback.Done();
    }

    private static JComponent computeWillFocusComponent(Content toSelect) {
        JComponent toFocus = toSelect.getPreferredFocusableComponent();
        if (toFocus != null) {
            toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(toFocus);
        }
        if (toFocus == null) {
            toFocus = toSelect.getPreferredFocusableComponent();
        }
        return toFocus;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/content/impl/ContentManagerImpl.addDataProvider must not be null");
        }
        this.myContentComponent.addProvider(provider);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("component".equals(evt.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)evt.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        if (contentFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/content/impl/ContentManagerImpl.getFactory must not return null");
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        this.myUI.beforeDispose();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myContents = null;
        this.mySelection = null;
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myListeners = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private class MyFocusProxy
    extends Wrapper.FocusHolder
    implements DataProvider {
        private MyFocusProxy() {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(0, 0));
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return ContentManagerImpl.this.myContentComponent.getData(dataId);
        }
    }

    private class MyContentComponent
    extends NonOpaquePanel
    implements DataProvider {
        private final List<DataProvider> myProviders = new ArrayList<DataProvider>();

        private MyContentComponent() {
        }

        public void addProvider(DataProvider provider) {
            this.myProviders.add(provider);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId)) {
                return ContentManagerImpl.this;
            }
            if (PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider each : this.myProviders) {
                Object data = each.getData(dataId);
                if (data == null) continue;
                return data;
            }
            return null;
        }
    }
}

