/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.containers.Convertor;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableSpeedSearch
extends SpeedSearchBase<JTable> {
    private static final Convertor<Object, String> TO_STRING = new Convertor<Object, String>(){

        public String convert(Object object) {
            return object == null ? "" : object.toString();
        }
    };
    private final Convertor<Object, String> myToStringConvertor;

    public TableSpeedSearch(JTable table, Convertor<Object, String> toStringConvertor) {
        super(table);
        this.myToStringConvertor = toStringConvertor;
    }

    public TableSpeedSearch(JTable table) {
        this(table, TO_STRING);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        return !((JTable)this.getComponent()).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected ListIterator<Object> getElementIterator(int startingIndex) {
        return new MyListIterator(startingIndex);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        int index = (Integer)element;
        TableModel model = ((JTable)this.myComponent).getModel();
        int row = index / model.getColumnCount();
        int col = index % model.getColumnCount();
        ((JTable)this.myComponent).getSelectionModel().setSelectionInterval(row, row);
        ((JTable)this.myComponent).getColumnModel().getSelectionModel().setSelectionInterval(col, col);
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    @Override
    protected int getSelectedIndex() {
        int row = ((JTable)this.myComponent).getSelectedRow();
        int col = ((JTable)this.myComponent).getSelectedColumn();
        return row > -1 && col > -1 ? row * ((JTable)this.myComponent).getModel().getColumnCount() + col : -1;
    }

    @Override
    protected Object[] getAllElements() {
        throw new AssertionError((Object)"Not Implemented");
    }

    @Override
    protected String getElementText(Object element) {
        int index = (Integer)element;
        TableModel model = ((JTable)this.myComponent).getModel();
        Object value = model.getValueAt(index / model.getColumnCount(), index % model.getColumnCount());
        String string = (String)this.myToStringConvertor.convert(value);
        if (string == null) {
            return (String)TO_STRING.convert(value);
        }
        return string;
    }

    private class MyListIterator
    implements ListIterator<Object> {
        private int myCursor;

        public MyListIterator(int startingIndex) {
            int total = this.getTotal();
            this.myCursor = startingIndex < 0 ? total : startingIndex;
        }

        private int getTotal() {
            TableModel tableModel = ((JTable)TableSpeedSearch.this.myComponent).getModel();
            return tableModel.getRowCount() * tableModel.getColumnCount();
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < this.getTotal();
        }

        @Override
        public Object next() {
            return this.myCursor++;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0;
        }

        @Override
        public Object previous() {
            return this.myCursor-- - 1;
        }

        @Override
        public int nextIndex() {
            return this.myCursor;
        }

        @Override
        public int previousIndex() {
            return this.myCursor - 1;
        }

        @Override
        public void remove() {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void set(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void add(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }
    }
}

