/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.GrowlNotifications;
import com.intellij.ui.SystemNotifications;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="SystemNotifications", storages={@Storage(id="SystemNotifications", file="$APP_CONFIG$/other.xml")})
public class SystemNotificationsImpl
implements SystemNotifications,
PersistentStateComponent<State> {
    private State myState = new State();
    private boolean myGrowlDisabled = false;

    @Override
    public void notify(@NotNull String notificationName, @NotNull String title, @NotNull String text) {
        GrowlNotifications nofications;
        if (notificationName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/SystemNotificationsImpl.notify must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/SystemNotificationsImpl.notify must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ui/SystemNotificationsImpl.notify must not be null");
        }
        if (!this.isGrowlEnabled() || ApplicationManager.getApplication().isActive()) {
            return;
        }
        try {
            nofications = GrowlNotifications.getNotifications();
        }
        catch (Throwable e) {
            this.myGrowlDisabled = true;
            return;
        }
        this.myState.NOTIFICATIONS.add(notificationName);
        nofications.notify(this.myState.NOTIFICATIONS, notificationName, title, text);
    }

    private boolean isGrowlEnabled() {
        if (this.myGrowlDisabled || !SystemInfo.isMac) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("growl.disable"))) {
            this.myGrowlDisabled = true;
        }
        return !this.myGrowlDisabled;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static class State {
        public Set<String> NOTIFICATIONS = new HashSet<String>();
    }
}

