/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.idea.Bombed;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.Timings;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformTestUtil {
    protected static final long ETALON_TIMING = 438L;
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));

    public static <T> void registerExtension(ExtensionPointName<T> name, T t, Disposable parentDisposable) {
        PlatformTestUtil.registerExtension(Extensions.getRootArea(), name, t, parentDisposable);
    }

    public static <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> name, final T t, Disposable parentDisposable) {
        final ExtensionPoint extensionPoint = area.getExtensionPoint(name.getName());
        extensionPoint.registerExtension(t);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(t);
            }
        });
    }

    protected static String toString(Object node, Queryable.PrintInfo printInfo) {
        if (node instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)node).toTestString(printInfo);
            }
            return ((AbstractTreeNode)node).getTestPresentation();
        }
        if (node == null) {
            return "NULL";
        }
        return node.toString();
    }

    public static String print(JTree tree, boolean withSelection) {
        return PlatformTestUtil.print(tree, withSelection, null);
    }

    public static String print(JTree tree, boolean withSelection, Condition<String> nodePrintCondition) {
        StringBuffer buffer = new StringBuffer();
        Object root = tree.getModel().getRoot();
        PlatformTestUtil.printImpl(tree, root, buffer, 0, withSelection, nodePrintCondition);
        return buffer.toString();
    }

    private static void printImpl(JTree tree, Object root, StringBuffer buffer, int level, boolean withSelection, @Nullable Condition<String> nodePrintCondition) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)root;
        Object userObject = defaultMutableTreeNode.getUserObject();
        String nodeText = userObject != null ? PlatformTestUtil.toString(userObject, null) : defaultMutableTreeNode + "";
        if (nodePrintCondition != null && !nodePrintCondition.value((Object)nodeText)) {
            return;
        }
        boolean expanded = tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()));
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)level);
        if (expanded && !defaultMutableTreeNode.isLeaf()) {
            buffer.append("-");
        }
        if (!expanded && !defaultMutableTreeNode.isLeaf()) {
            buffer.append("+");
        }
        boolean selected = tree.getSelectionModel().isPathSelected(new TreePath(defaultMutableTreeNode.getPath()));
        if (withSelection && selected) {
            buffer.append("[");
        }
        buffer.append(nodeText);
        if (withSelection && selected) {
            buffer.append("]");
        }
        buffer.append("\n");
        int childCount = tree.getModel().getChildCount(root);
        if (expanded) {
            for (int i = 0; i < childCount; ++i) {
                PlatformTestUtil.printImpl(tree, tree.getModel().getChild(root, i), buffer, level + 1, withSelection, nodePrintCondition);
            }
        }
    }

    public static void assertTreeEqual(JTree tree, @NonNls String expected) {
        PlatformTestUtil.assertTreeEqual(tree, expected, false);
    }

    public static void assertTreeEqual(JTree tree, String expected, boolean checkSelected) {
        String treeStringPresentation = PlatformTestUtil.print(tree, checkSelected);
        Assert.assertEquals((String)expected, (String)treeStringPresentation);
    }

    public static void waitForAlarm(final int delay) throws InterruptedException {
        final boolean[] invoked = new boolean[]{false};
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        alarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                invoked[0] = true;
                            }
                        }, delay);
                    }
                });
            }
        }, delay);
        UIUtil.dispatchAllInvocationEvents();
        while (!invoked[0]) {
            UIUtil.dispatchAllInvocationEvents();
            Thread.sleep(delay);
        }
    }

    private static Date raidDate(Bombed bombed) {
        Calendar instance = Calendar.getInstance();
        instance.set(1, bombed.year());
        instance.set(2, bombed.month());
        instance.set(5, bombed.day());
        instance.set(11, bombed.time());
        instance.set(12, 0);
        Date time = instance.getTime();
        return time;
    }

    public static boolean bombExplodes(Bombed bombedAnnotation) {
        Date now = new Date();
        return now.after(PlatformTestUtil.raidDate(bombedAnnotation));
    }

    public static boolean bombExplodes(int year, int month, int day, int h, int m, String who, String message) {
        Calendar instance = Calendar.getInstance();
        instance.set(1, year);
        instance.set(2, month);
        instance.set(5, day);
        instance.set(11, h);
        instance.set(12, m);
        Date time = instance.getTime();
        return PlatformTestUtil.isItMe(who) || new Date().after(time);
    }

    public static boolean isRotten(Bombed bomb) {
        long bombRotPeriod = 2592000000L;
        return new Date().after(new Date(PlatformTestUtil.raidDate(bomb).getTime() + bombRotPeriod));
    }

    private static boolean isItMe(String who) {
        return Comparing.equal((String)who, (String)SystemProperties.getUserName(), (boolean)false);
    }

    public static StringBuffer print(AbstractTreeStructure structure, Object node, int currentLevel, Comparator comparator, int maxRowCount, char paddingChar) {
        return PlatformTestUtil.print(structure, node, currentLevel, comparator, maxRowCount, paddingChar, null);
    }

    public static StringBuffer print(AbstractTreeStructure structure, Object node, int currentLevel, Comparator comparator, int maxRowCount, char paddingChar, Queryable.PrintInfo printInfo) {
        StringBuffer buffer = new StringBuffer();
        PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator, maxRowCount, 0, paddingChar, printInfo);
        return buffer;
    }

    private static int doPrint(StringBuffer buffer, int currentLevel, Object node, AbstractTreeStructure structure, Comparator comparator, int maxRowCount, int currentLine, char paddingChar) {
        return PlatformTestUtil.doPrint(buffer, currentLevel, node, structure, comparator, maxRowCount, currentLine, paddingChar, null);
    }

    private static int doPrint(StringBuffer buffer, int currentLevel, Object node, AbstractTreeStructure structure, Comparator comparator, int maxRowCount, int currentLine, char paddingChar, Queryable.PrintInfo printInfo) {
        if (currentLine >= maxRowCount && maxRowCount != -1) {
            return currentLine;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)paddingChar, (int)currentLevel);
        buffer.append(PlatformTestUtil.toString(node, printInfo)).append("\n");
        ++currentLine;
        Object[] children = structure.getChildElements(node);
        if (comparator != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(children));
            Collections.sort(list, comparator);
            children = ArrayUtil.toObjectArray(list);
        }
        for (Object child : children) {
            currentLine = PlatformTestUtil.doPrint(buffer, currentLevel + 1, child, structure, comparator, maxRowCount, currentLine, paddingChar, printInfo);
        }
        return currentLine;
    }

    public static String print(Object[] objects) {
        return PlatformTestUtil.print(Arrays.asList(objects));
    }

    public static String print(Collection c) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object each = iterator.next();
            result.append(PlatformTestUtil.toString(each, null));
            if (!iterator.hasNext()) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(ListModel model) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            result.append(PlatformTestUtil.toString(model.getElementAt(i), null));
            result.append("\n");
        }
        return result.toString();
    }

    public static String print(JTree tree) {
        return PlatformTestUtil.print(tree, false);
    }

    public static void assertTreeStructureEquals(AbstractTreeStructure treeStructure, String expected) {
        Assert.assertEquals((String)expected, (String)PlatformTestUtil.print(treeStructure, treeStructure.getRootElement(), 0, null, -1, ' ').toString());
    }

    public static void invokeNamedAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        Assert.assertNotNull((Object)action);
        Presentation presentation = new Presentation();
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), "", presentation, ActionManager.getInstance(), 0);
        action.update(event);
        Assert.assertTrue((boolean)presentation.isEnabled());
        action.actionPerformed(event);
    }

    public static void assertTiming(String message, long expected, long actual) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long expectedOnMyMachine = Math.max(1L, expected * Timings.MACHINE_TIMING / 438L);
        double acceptableChangeFactor = 1.1;
        int percentage = (int)(100.0 * (double)(actual - expectedOnMyMachine) / (double)expectedOnMyMachine);
        String failMessage = message + "." + " Operation took " + percentage + "% longer than expected." + " Expected on my machine: " + expectedOnMyMachine + "." + " Actual: " + actual + "." + " Expected on Etalon machine: " + expected + ";" + " Actual on Etalon: " + actual * 438L / Timings.MACHINE_TIMING;
        if ((double)actual > (double)expectedOnMyMachine * 1.1 && (expectedOnMyMachine > expected || (double)actual > (double)expected * 1.1)) {
            Assert.fail((String)failMessage);
        } else {
            System.out.println(failMessage);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(String message, long expected, @NotNull Runnable runnable) {
        void actionToMeasure;
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/testFramework/PlatformTestUtil.assertTiming must not be null");
        }
        PlatformTestUtil.assertTiming(message, expected, 4, (Runnable)actionToMeasure);
    }

    public static long measure(@NotNull Runnable actionToMeasure) {
        if (actionToMeasure == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/PlatformTestUtil.measure must not be null");
        }
        long start = System.currentTimeMillis();
        actionToMeasure.run();
        long finish = System.currentTimeMillis();
        return finish - start;
    }

    /*
     * WARNING - void declaration
     */
    public static void assertTiming(String message, long expected, int attempts, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/testFramework/PlatformTestUtil.assertTiming must not be null");
        }
        while (true) {
            void actionToMeasure;
            --attempts;
            long duration = PlatformTestUtil.measure((Runnable)actionToMeasure);
            try {
                PlatformTestUtil.assertTiming(message, expected, duration);
            }
            catch (AssertionFailedError e) {
                if (attempts == 0) {
                    throw e;
                }
                System.gc();
                System.gc();
                System.gc();
                System.out.println("Another epic fail: " + e.getMessage() + "; Attempts remained: " + attempts);
                continue;
            }
            break;
        }
    }
}

