/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.forward.SliceFUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceUtil {
    public static boolean processUsagesFlownDownTo(@NotNull PsiElement expression, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.processUsagesFlownDownTo must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.processUsagesFlownDownTo must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.processUsagesFlownDownTo must not be null");
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/slicer/SliceUtil.processUsagesFlownDownTo must not be null");
        }
        PsiElement original = expression = SliceUtil.simplify(expression);
        if (expression instanceof PsiReferenceExpression) {
            PsiElement element = SliceFUtil.complexify(expression);
            if (element instanceof PsiExpression && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) {
                PsiExpression rightSide = ((PsiAssignmentExpression)element.getParent()).getRExpression();
                return rightSide == null || SliceUtil.handToProcessor(rightSide, processor, parent, parentSubstitutor);
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            JavaResolveResult result = ref.advancedResolve(false);
            parentSubstitutor = result.getSubstitutor().putAll(parentSubstitutor);
            PsiElement resolved = result.getElement();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            if (resolved instanceof PsiMethod && expression.getParent() instanceof PsiMethodCallExpression) {
                return SliceUtil.processUsagesFlownDownTo(expression.getParent(), processor, parent, parentSubstitutor);
            }
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            expression = resolved;
        }
        if (expression instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)expression;
            Collection<PsiExpression> values = DfaUtil.getCachedVariableValues(variable, original);
            if (values == null) {
                SliceUsage stopUsage = SliceUtil.createTooComplexDFAUsage(expression, parent, parentSubstitutor);
                return processor.process((Object)stopUsage);
            }
            THashSet expressions = new THashSet(values);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && expressions.isEmpty()) {
                expressions.add(initializer);
            }
            for (PsiExpression exp : expressions) {
                if (SliceUtil.handToProcessor(exp, processor, parent, parentSubstitutor)) continue;
                return false;
            }
            if (variable instanceof PsiField) {
                return SliceUtil.processFieldUsages((PsiField)variable, processor, parent, parentSubstitutor);
            }
            if (variable instanceof PsiParameter) {
                return SliceUtil.processParameterUsages((PsiParameter)variable, processor, parent, parentSubstitutor);
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            return SliceUtil.processMethodReturnValue((PsiMethodCallExpression)expression, processor, parent, parentSubstitutor);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            if (thenE != null && !SliceUtil.handToProcessor(thenE, processor, parent, parentSubstitutor)) {
                return false;
            }
            if (elseE != null && !SliceUtil.handToProcessor(elseE, processor, parent, parentSubstitutor)) {
                return false;
            }
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression rExpression = assignment.getRExpression();
            if (tokenType == JavaTokenType.EQ && rExpression != null) {
                return SliceUtil.processUsagesFlownDownTo((PsiElement)rExpression, processor, parent, parentSubstitutor);
            }
        }
        return true;
    }

    private static PsiElement simplify(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.simplify must not be null");
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return SliceUtil.simplify((PsiElement)((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiTypeCastExpression) {
            return SliceUtil.simplify((PsiElement)((PsiTypeCastExpression)expression).getOperand());
        }
        return expression;
    }

    private static boolean handToProcessor(@NotNull PsiExpression exp, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor) {
        SliceUsage usage;
        PsiExpression realExpression;
        if (exp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.handToProcessor must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.handToProcessor must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.handToProcessor must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/slicer/SliceUtil.handToProcessor must not be null");
        }
        PsiExpression psiExpression = realExpression = exp.getParent() instanceof DummyHolder ? (PsiExpression)((DummyHolder)exp.getParent()).getContext() : exp;
        assert (realExpression != null);
        return realExpression instanceof PsiCompiledElement || processor.process((Object)(usage = SliceUtil.createSliceUsage((PsiElement)realExpression, parent, substitutor)));
    }

    private static boolean processMethodReturnValue(@NotNull PsiMethodCallExpression methodCallExpr, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor) {
        if (methodCallExpr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.processMethodReturnValue must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.processMethodReturnValue must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.processMethodReturnValue must not be null");
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/slicer/SliceUtil.processMethodReturnValue must not be null");
        }
        JavaResolveResult resolved = methodCallExpr.resolveMethodGenerics();
        PsiElement r = resolved.getElement();
        if (r instanceof PsiCompiledElement) {
            r = r.getNavigationElement();
        }
        if (!(r instanceof PsiMethod)) {
            return true;
        }
        PsiMethod methodCalled = (PsiMethod)r;
        PsiType returnType = methodCalled.getReturnType();
        if (returnType == null) {
            return true;
        }
        final PsiType parentType = parentSubstitutor.substitute(methodCallExpr.getType());
        final PsiSubstitutor substitutor = resolved.getSubstitutor().putAll(parentSubstitutor);
        THashSet overrides = new THashSet(OverridingMethodsSearch.search((PsiMethod)methodCalled, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).findAll());
        overrides.add(methodCalled);
        final boolean[] result = new boolean[]{true};
        for (PsiMethod override : overrides) {
            PsiCodeBlock body;
            if (!result[0]) break;
            if (override instanceof PsiCompiledElement) {
                override = (PsiMethod)override.getNavigationElement();
            }
            if (!parent.getScope().contains((PsiElement)override) || (body = override.getBody()) == null) continue;
            PsiSubstitutor s = methodCalled == override ? substitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodCalled.getSignature(substitutor), (MethodSignature)override.getSignature(substitutor));
            final PsiSubstitutor superSubstitutor = s == null ? parentSubstitutor : s;
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                }

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiExpression returnValue = statement.getReturnValue();
                    if (returnValue == null) {
                        return;
                    }
                    if (!TypeConversionUtil.isAssignable((PsiType)parentType, (PsiType)superSubstitutor.substitute(superSubstitutor.substitute(returnValue.getType())))) {
                        return;
                    }
                    if (!SliceUtil.handToProcessor(returnValue, (Processor<SliceUsage>)processor, parent, substitutor)) {
                        this.stopWalking();
                        result[0] = false;
                    }
                }
            });
        }
        return result[0];
    }

    private static boolean processFieldUsages(final @NotNull PsiField field, final @NotNull Processor<SliceUsage> processor, final @NotNull SliceUsage parent, final @NotNull PsiSubstitutor parentSubstitutor) {
        PsiExpression initializer;
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.processFieldUsages must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.processFieldUsages must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.processFieldUsages must not be null");
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/slicer/SliceUtil.processFieldUsages must not be null");
        }
        if (field.hasInitializer() && (initializer = field.getInitializer()) != null && !(field instanceof PsiCompiledElement) && !SliceUtil.handToProcessor(initializer, processor, parent, parentSubstitutor)) {
            return false;
        }
        SearchScope searchScope = parent.getScope().toSearchScope();
        return ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                SliceManager.getInstance(field.getProject()).checkCanceled();
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return true;
                }
                if (element instanceof PsiCompiledElement) {
                    element = element.getNavigationElement();
                    if (!parent.getScope().contains(element)) {
                        return true;
                    }
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parentExpr = referenceExpression.getParent();
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referenceExpression)) {
                    PsiExpression rExpression = ((PsiAssignmentExpression)parentExpr).getRExpression();
                    PsiType rtype = rExpression.getType();
                    PsiType ftype = field.getType();
                    if (TypeConversionUtil.isAssignable((PsiType)parentSubstitutor.substitute(ftype), (PsiType)parentSubstitutor.substitute(rtype))) {
                        return SliceUtil.handToProcessor(rExpression, (Processor<SliceUsage>)processor, parent, parentSubstitutor);
                    }
                }
                if (parentExpr instanceof PsiPrefixExpression && ((PsiPrefixExpression)parentExpr).getOperand() == referenceExpression && (((PsiPrefixExpression)parentExpr).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPrefixExpression)parentExpr).getOperationTokenType() == JavaTokenType.MINUSMINUS)) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parentExpr;
                    return SliceUtil.handToProcessor((PsiExpression)prefixExpression, (Processor<SliceUsage>)processor, parent, parentSubstitutor);
                }
                if (parentExpr instanceof PsiPostfixExpression && ((PsiPostfixExpression)parentExpr).getOperand() == referenceExpression && (((PsiPostfixExpression)parentExpr).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPostfixExpression)parentExpr).getOperationTokenType() == JavaTokenType.MINUSMINUS)) {
                    PsiPostfixExpression postfixExpression = (PsiPostfixExpression)parentExpr;
                    return SliceUtil.handToProcessor((PsiExpression)postfixExpression, (Processor<SliceUsage>)processor, parent, parentSubstitutor);
                }
                return true;
            }
        });
    }

    public static SliceUsage createSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.createSliceUsage must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.createSliceUsage must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.createSliceUsage must not be null");
        }
        return new SliceUsage(SliceUtil.simplify(element), parent, substitutor);
    }

    public static SliceUsage createTooComplexDFAUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.createTooComplexDFAUsage must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.createTooComplexDFAUsage must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.createTooComplexDFAUsage must not be null");
        }
        return new SliceTooComplexDFAUsage(SliceUtil.simplify(element), parent, substitutor);
    }

    static boolean processParameterUsages(final @NotNull PsiParameter parameter, @NotNull Processor<SliceUsage> processor, @NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor) {
        if (parameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.processParameterUsages must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.processParameterUsages must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.processParameterUsages must not be null");
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/slicer/SliceUtil.processParameterUsages must not be null");
        }
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (!(declarationScope instanceof PsiMethod)) {
            return true;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        PsiType actualType = parameter.getType();
        Object[] actualParameters = method.getParameterList().getParameters();
        int paramSeqNo = ArrayUtil.find((Object[])actualParameters, (Object)parameter);
        assert (paramSeqNo != -1);
        THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
        superMethods.add(method);
        THashSet processed = new THashSet();
        for (PsiMethod superMethod : superMethods) {
            if (MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach((Processor)new Processor<PsiReference>((Set)processed, paramSeqNo, (PsiParameter[])actualParameters, parentSubstitutor, actualType, processor, parent){
                final /* synthetic */ Set val$processed;
                final /* synthetic */ int val$paramSeqNo;
                final /* synthetic */ PsiParameter[] val$actualParameters;
                final /* synthetic */ PsiSubstitutor val$parentSubstitutor;
                final /* synthetic */ PsiType val$actualType;
                final /* synthetic */ Processor val$processor;
                final /* synthetic */ SliceUsage val$parent;
                {
                    this.val$processed = set;
                    this.val$paramSeqNo = n;
                    this.val$actualParameters = psiParameterArray;
                    this.val$parentSubstitutor = psiSubstitutor;
                    this.val$actualType = psiType;
                    this.val$processor = processor;
                    this.val$parent = sliceUsage;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(PsiReference reference) {
                    PsiSubstitutor combined;
                    JavaResolveResult result;
                    PsiExpressionList argumentList;
                    SliceManager.getInstance(parameter.getProject()).checkCanceled();
                    Set set = this.val$processed;
                    synchronized (set) {
                        if (!this.val$processed.add(reference)) {
                            return true;
                        }
                    }
                    PsiElement refElement = reference.getElement();
                    if (refElement instanceof PsiCall) {
                        PsiCall call = (PsiCall)refElement;
                        argumentList = call.getArgumentList();
                        result = call.resolveMethodGenerics();
                    } else {
                        PsiElement element = refElement.getParent();
                        if (element instanceof PsiCompiledElement) {
                            return true;
                        }
                        if (element instanceof PsiAnonymousClass) {
                            PsiAnonymousClass anon = (PsiAnonymousClass)element;
                            argumentList = anon.getArgumentList();
                            PsiElement callExp = element.getParent();
                            if (!(callExp instanceof PsiCallExpression)) {
                                return true;
                            }
                            result = ((PsiCall)callExp).resolveMethodGenerics();
                        } else {
                            if (!(element instanceof PsiCall)) {
                                return true;
                            }
                            PsiCall call = (PsiCall)element;
                            argumentList = call.getArgumentList();
                            result = call.resolveMethodGenerics();
                        }
                    }
                    PsiSubstitutor substitutor = result.getSubstitutor();
                    PsiExpression[] expressions = argumentList.getExpressions();
                    if (this.val$paramSeqNo >= expressions.length) {
                        return true;
                    }
                    PsiExpression passExpression = expressions[this.val$paramSeqNo];
                    Project project = argumentList.getProject();
                    PsiElement element = result.getElement();
                    if (element instanceof PsiCompiledElement) {
                        element = element.getNavigationElement();
                    }
                    if (element instanceof PsiTypeParameterListOwner && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)element), (PsiSubstitutor)substitutor)) {
                        PsiTypeParameter[] typeParameters = substitutor.getSubstitutionMap().keySet().toArray(new PsiTypeParameter[0]);
                        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
                        substitutor = resolveHelper.inferTypeArguments(typeParameters, this.val$actualParameters, expressions, this.val$parentSubstitutor, (PsiElement)argumentList, false);
                    }
                    if ((combined = SliceUtil.unify(substitutor = SliceUtil.removeRawMappingsLeftFromResolve(substitutor), this.val$parentSubstitutor, project)) == null) {
                        return true;
                    }
                    PsiType substitited = combined.substitute(passExpression.getType());
                    if (substitited == null || !TypeConversionUtil.areTypesConvertible((PsiType)substitited, (PsiType)this.val$actualType)) {
                        return true;
                    }
                    return SliceUtil.handToProcessor(passExpression, (Processor<SliceUsage>)this.val$processor, this.val$parent, combined);
                }
            })) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiSubstitutor removeRawMappingsLeftFromResolve(@NotNull PsiSubstitutor substitutor) {
        PsiSubstitutor psiSubstitutor;
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.removeRawMappingsLeftFromResolve must not be null");
        }
        Map map = null;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            if (entry.getValue() != null) continue;
            if (map == null) {
                map = new THashMap();
            }
            map.put(entry.getKey(), entry.getValue());
        }
        if (map == null) {
            psiSubstitutor = substitutor;
            if (psiSubstitutor == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceUtil.removeRawMappingsLeftFromResolve must not return null");
            return psiSubstitutor;
        }
        THashMap newmap = new THashMap(substitutor.getSubstitutionMap());
        newmap.keySet().removeAll(map.keySet());
        psiSubstitutor = PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)newmap);
        if (psiSubstitutor != null) return psiSubstitutor;
        throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceUtil.removeRawMappingsLeftFromResolve must not return null");
    }

    @Nullable
    private static PsiSubstitutor unify(@NotNull PsiSubstitutor substitutor, @NotNull PsiSubstitutor parentSubstitutor, @NotNull Project project) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceUtil.unify must not be null");
        }
        if (parentSubstitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceUtil.unify must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/slicer/SliceUtil.unify must not be null");
        }
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            PsiType type = (PsiType)entry.getValue();
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type);
            if (!parentSubstitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType parentType = parentSubstitutor.substitute(parentSubstitutor.substitute(typeParameter));
            if (resolved instanceof PsiTypeParameter) {
                PsiTypeParameter res = (PsiTypeParameter)resolved;
                newMap.put(res, parentType);
                continue;
            }
            if (Comparing.equal((Object)type, (Object)parentType)) continue;
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createSubstitutor((Map)newMap);
    }
}

