/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringConflictsUtil {
    public static void analyzeAccessibilityConflicts(@NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass, MultiMap<PsiElement, String> conflicts, String newVisibility) {
        if (membersToMove == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.analyzeAccessibilityConflicts must not be null");
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.analyzeAccessibilityConflicts must not be null");
        }
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(membersToMove, targetClass, conflicts, newVisibility, (PsiElement)targetClass, null);
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<PsiMember> membersToMove, @Nullable PsiClass targetClass, MultiMap<PsiElement, String> conflicts, String newVisibility, @NotNull PsiElement context, @Nullable Set<PsiMethod> abstractMethods) {
        if (membersToMove == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.analyzeAccessibilityConflicts must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.analyzeAccessibilityConflicts must not be null");
        }
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        for (PsiMember member : membersToMove) {
            RefactoringConflictsUtil.checkUsedElements(member, (PsiElement)member, membersToMove, abstractMethods, targetClass, context, conflicts);
            PsiModifierList modifierList = member.getModifierList();
            if (modifierList != null) {
                modifierList = (PsiModifierList)modifierList.copy();
            }
            if (newVisibility != null) {
                try {
                    if (modifierList != null) {
                        VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)newVisibility);
                    }
                }
                catch (IncorrectOperationException ex) {
                    // empty catch block
                }
            }
            JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)member.getProject());
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
                String message;
                PsiElement ref = psiReference.getElement();
                if (RefactoringHierarchyUtil.willBeInTargetClass(ref, membersToMove, targetClass, false)) continue;
                if (targetClass != null && !manager.getResolveHelper().isAccessible((PsiMember)targetClass, targetClass.getModifierList(), ref, null, null)) {
                    message = RefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)targetClass), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(ref), true)});
                    message = CommonRefactoringUtil.capitalize((String)message);
                    conflicts.putValue((Object)targetClass, (Object)message);
                    continue;
                }
                if (manager.getResolveHelper().isAccessible(member, modifierList, ref, null, null)) continue;
                message = RefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(ref), true)});
                message = CommonRefactoringUtil.capitalize((String)message);
                conflicts.putValue((Object)member, (Object)message);
            }
        }
    }

    public static void checkUsedElements(PsiMember member, PsiElement scope, @NotNull Set<PsiMember> membersToMove, @Nullable Set<PsiMethod> abstractMethods, @Nullable PsiClass targetClass, @NotNull PsiElement context, MultiMap<PsiElement, String> conflicts) {
        PsiElement[] children;
        PsiElement refElement;
        PsiReferenceExpression refExpr;
        if (membersToMove == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.checkUsedElements must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.checkUsedElements must not be null");
        }
        HashSet moving = new HashSet(membersToMove);
        if (abstractMethods != null) {
            moving.addAll(abstractMethods);
        }
        if (scope instanceof PsiReferenceExpression) {
            refExpr = (PsiReferenceExpression)scope;
            refElement = refExpr.resolve();
            if (refElement instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass(refElement, (Set<PsiMember>)moving, targetClass, false)) {
                PsiExpression qualifier = refExpr.getQualifierExpression();
                PsiClass accessClass = (PsiClass)(qualifier != null ? PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement() : null);
                RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement, context, accessClass, member, conflicts);
            }
        } else if (scope instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)scope;
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass != null) {
                if (!RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)anonymousClass, (Set<PsiMember>)moving, targetClass, false)) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)anonymousClass, context, (PsiClass)anonymousClass, member, conflicts);
                }
            } else {
                PsiMethod refElement2 = newExpression.resolveConstructor();
                if (refElement2 != null && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement2, (Set<PsiMember>)moving, targetClass, false)) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement2, context, null, member, conflicts);
                }
            }
        } else if (scope instanceof PsiJavaCodeReferenceElement && (refElement = (refExpr = (PsiJavaCodeReferenceElement)scope).resolve()) instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass(refElement, (Set<PsiMember>)moving, targetClass, false)) {
            RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement, context, null, member, conflicts);
        }
        for (PsiElement child : children = scope.getChildren()) {
            if (child instanceof PsiWhiteSpace) continue;
            RefactoringConflictsUtil.checkUsedElements(member, child, membersToMove, abstractMethods, targetClass, context, conflicts);
        }
    }

    public static void checkAccessibility(PsiMember refMember, @NotNull PsiElement newContext, PsiClass accessClass, PsiMember member, MultiMap<PsiElement, String> conflicts) {
        PsiField fieldInSubClass;
        if (newContext == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/RefactoringConflictsUtil.checkAccessibility must not be null");
        }
        if (!PsiUtil.isAccessible((PsiMember)refMember, (PsiElement)newContext, (PsiClass)accessClass)) {
            String message = RefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)refMember, true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)refMember), RefactoringUIUtil.getDescription((PsiElement)member, false)});
            message = CommonRefactoringUtil.capitalize((String)message);
            conflicts.putValue((Object)refMember, (Object)message);
        } else if (newContext instanceof PsiClass && refMember instanceof PsiField && refMember.getContainingClass() == member.getContainingClass() && (fieldInSubClass = ((PsiClass)newContext).findFieldByName(refMember.getName(), false)) != null) {
            conflicts.putValue((Object)refMember, (Object)CommonRefactoringUtil.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)fieldInSubClass, true) + " would hide " + RefactoringUIUtil.getDescription((PsiElement)refMember, true) + " which is used by moved " + RefactoringUIUtil.getDescription((PsiElement)member, false))));
        }
    }

    public static void analyzeModuleConflicts(Project project, Collection<? extends PsiElement> scope, UsageInfo[] usages, PsiElement target, MultiMap<PsiElement, String> conflicts) {
        if (scope == null) {
            return;
        }
        VirtualFile vFile = PsiUtilBase.getVirtualFile((PsiElement)target);
        if (vFile == null) {
            return;
        }
        RefactoringConflictsUtil.analyzeModuleConflicts(project, scope, usages, vFile, conflicts);
    }

    public static void analyzeModuleConflicts(Project project, final Collection<? extends PsiElement> scopes, UsageInfo[] usages, VirtualFile vFile, final MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        for (PsiElement psiElement : scopes) {
            if (!(psiElement instanceof PsiPackage) && !(psiElement instanceof PsiDirectory)) continue;
            return;
        }
        final Module targetModule = ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null) {
            return;
        }
        final GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        for (PsiElement psiElement : scopes) {
            psiElement.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    super.visitReferenceElement(reference);
                    PsiElement resolved = reference.resolve();
                    if (!(resolved == null || reported.contains((Object)resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || PsiSearchScopeUtil.isInScope((GlobalSearchScope)globalSearchScope, (PsiElement)resolved))) {
                        String scopeDescription = RefactoringUIUtil.getDescription(ConflictsUtil.getContainer((PsiElement)reference), true);
                        String message = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription(resolved, true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                        conflicts.putValue((Object)resolved, (Object)message);
                        reported.add((Object)resolved);
                    }
                }
            });
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile);
        block2: for (UsageInfo usage : usages) {
            Module module;
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsageInfo = (MoveRenameUsageInfo)usage;
            PsiElement element = usage.getElement();
            if (element == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
                continue block2;
            }
            GlobalSearchScope resolveScope1 = element.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element.getContainingFile();
            Object container = psiFile instanceof PsiJavaFile ? ConflictsUtil.getContainer(element) : psiFile;
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            PsiElement referencedElement = moveRenameUsageInfo.getReferencedElement();
            String message = module == targetModule && isInTestSources ? RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription(referencedElement, true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())}) : RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{CommonRefactoringUtil.capitalize((String)RefactoringUIUtil.getDescription(referencedElement, true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            conflicts.putValue((Object)referencedElement, (Object)message);
        }
    }
}

