/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class ParameterTablePanel
extends JPanel {
    private final Project myProject;
    private final VariableData[] myVariableData;
    private final TypeSelector[] myParameterTypeSelectors;
    private final Table myTable;
    private final MyTableModel myTableModel;
    private final JButton myUpButton;
    private final JButton myDownButton;
    private final JComboBox myTypeRendererCombo;

    public VariableData[] getVariableData() {
        return this.myVariableData;
    }

    protected abstract void updateSignature();

    protected abstract void doEnterAction();

    protected abstract void doCancelAction();

    protected boolean areTypesDirected() {
        return true;
    }

    public ParameterTablePanel(Project project, VariableData[] variableData, PsiElement ... scopeElements) {
        super(new BorderLayout());
        this.myProject = project;
        this.myVariableData = variableData;
        this.myTableModel = new MyTableModel();
        this.myTable = new Table((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.setTableHeader(null);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new CheckBoxTableCellRenderer()));
        this.myTable.getColumnModel().getColumn(0).setMaxWidth(new JCheckBox().getPreferredSize().width);
        this.myTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                VariableData data = ParameterTablePanel.this.getVariableData()[row];
                this.setText(data.name);
                return this;
            }
        });
        this.myParameterTypeSelectors = new TypeSelector[this.getVariableData().length];
        for (int i = 0; i < this.myParameterTypeSelectors.length; ++i) {
            PsiExpression[] occurrences = ParameterTablePanel.findVariableOccurrences(scopeElements, this.getVariableData()[i].variable);
            TypeSelectorManagerImpl manager = new TypeSelectorManagerImpl(this.myProject, this.getVariableData()[i].type, occurrences, this.areTypesDirected());
            this.myParameterTypeSelectors[i] = manager.getTypeSelector();
            this.getVariableData()[i].type = this.myParameterTypeSelectors[i].getSelectedType();
        }
        this.myTypeRendererCombo = new JComboBox<VariableData>(this.getVariableData());
        this.myTypeRendererCombo.setOpaque(true);
        this.myTypeRendererCombo.setBorder(null);
        this.myTypeRendererCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((VariableData)value).type.getPresentableText());
                return this;
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            TypeSelector myCurrentSelector;

            public Object getCellEditorValue() {
                return this.myCurrentSelector.getSelectedType();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myCurrentSelector = ParameterTablePanel.this.myParameterTypeSelectors[row];
                return this.myCurrentSelector.getComponent();
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (ParameterTablePanel.this.myParameterTypeSelectors[row].getComponent() instanceof JComboBox) {
                    ParameterTablePanel.this.myTypeRendererCombo.setSelectedIndex(row);
                    return ParameterTablePanel.this.myTypeRendererCombo;
                }
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                VariableData data = ParameterTablePanel.this.getVariableData()[row];
                this.setText(data.type.getPresentableText());
                return this;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = ParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (ParameterTablePanel.this.getVariableData()[row].passAsParameter) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ParameterTablePanel.this.getVariableData()[row].passAsParameter = valueToBeSet;
                    }
                    ParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)ParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "edit_parameter_name");
        actionMap.put("edit_parameter_name", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ParameterTablePanel.this.myTable.isEditing() && (row = ParameterTablePanel.this.myTable.getSelectedRow()) >= 0 && row < ParameterTablePanel.this.myTableModel.getRowCount()) {
                    TableUtil.editCellAt((JTable)ParameterTablePanel.this.myTable, (int)row, (int)2);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invokeImpl");
        actionMap.put("invokeImpl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doEnterAction();
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doCancelAction();
                }
            }
        });
        JPanel listPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
        listPanel.add((Component)scrollPane, "Center");
        listPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)listPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)buttonsPanel, "East");
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(2, 4, 2, 4);
        this.myUpButton = new JButton();
        this.myUpButton.setText(UIBundle.message((String)"row.move.up", (Object[])new Object[0]));
        this.myUpButton.setDefaultCapable(false);
        buttonsPanel.add((Component)this.myUpButton, gbConstraints);
        this.myDownButton = new JButton();
        this.myDownButton.setText(UIBundle.message((String)"row.move.down", (Object[])new Object[0]));
        this.myDownButton.setDefaultCapable(false);
        buttonsPanel.add((Component)this.myDownButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        buttonsPanel.add((Component)new JPanel(), gbConstraints);
        this.myUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isStopped;
                if (ParameterTablePanel.this.myTable.isEditing() && !(isStopped = ParameterTablePanel.this.myTable.getCellEditor().stopCellEditing())) {
                    return;
                }
                ParameterTablePanel.this.moveSelectedItem(-1);
                ParameterTablePanel.this.updateSignature();
                ParameterTablePanel.this.myTable.requestFocus();
            }
        });
        this.myDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isStopped;
                if (ParameterTablePanel.this.myTable.isEditing() && !(isStopped = ParameterTablePanel.this.myTable.getCellEditor().stopCellEditing())) {
                    return;
                }
                ParameterTablePanel.this.moveSelectedItem(1);
                ParameterTablePanel.this.updateSignature();
                ParameterTablePanel.this.myTable.requestFocus();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ParameterTablePanel.this.updateMoveButtons();
            }
        });
        if (this.getVariableData().length <= 1) {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        } else {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.updateMoveButtons();
    }

    private static PsiExpression[] findVariableOccurrences(PsiElement[] scopeElements, final PsiVariable variable) {
        final ArrayList result = new ArrayList();
        for (PsiElement element : scopeElements) {
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    if (!expression.isQualified() && expression.isReferenceTo((PsiElement)variable)) {
                        result.add(expression);
                    }
                }
            });
        }
        return result.toArray(new PsiExpression[result.size()]);
    }

    private void updateMoveButtons() {
        int row = this.myTable.getSelectedRow();
        if (0 <= row && row < this.getVariableData().length) {
            this.myUpButton.setEnabled(row > 0);
            this.myDownButton.setEnabled(row < this.getVariableData().length - 1);
        } else {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        }
    }

    private void moveSelectedItem(int moveIncrement) {
        int row = this.myTable.getSelectedRow();
        if (row < 0 || row >= this.getVariableData().length) {
            return;
        }
        int targetRow = row + moveIncrement;
        if (targetRow < 0 || targetRow >= this.getVariableData().length) {
            return;
        }
        VariableData currentItem = this.getVariableData()[row];
        this.getVariableData()[row] = this.getVariableData()[targetRow];
        this.getVariableData()[targetRow] = currentItem;
        TypeSelector currentSelector = this.myParameterTypeSelectors[row];
        this.myParameterTypeSelectors[row] = this.myParameterTypeSelectors[targetRow];
        this.myParameterTypeSelectors[targetRow] = currentSelector;
        this.myTypeRendererCombo.setModel(new DefaultComboBoxModel<VariableData>(this.getVariableData()));
        this.myTableModel.fireTableRowsUpdated(Math.min(targetRow, row), Math.max(targetRow, row));
        this.myTable.getSelectionModel().setSelectionInterval(targetRow, targetRow);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
        if (!enabled) {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        } else {
            this.updateMoveButtons();
        }
        super.setEnabled(enabled);
    }

    private class CheckBoxTableCellRenderer
    extends BooleanTableCellRenderer {
        private CheckBoxTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setEnabled(ParameterTablePanel.this.isEnabled());
            return rendererComponent;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_TYPE_COLUMN = 1;
        public static final int PARAMETER_NAME_COLUMN = 2;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return ParameterTablePanel.this.getVariableData().length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return ParameterTablePanel.this.getVariableData()[rowIndex].name;
                }
                case 1: {
                    return ParameterTablePanel.this.getVariableData()[rowIndex].type.getPresentableText();
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter = (Boolean)aValue;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 2: {
                    VariableData data = ParameterTablePanel.this.getVariableData()[rowIndex];
                    String name = (String)aValue;
                    if (JavaPsiFacade.getInstance((Project)ParameterTablePanel.this.myProject).getNameHelper().isIdentifier(name)) {
                        data.name = name;
                    }
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    VariableData data = ParameterTablePanel.this.getVariableData()[rowIndex];
                    data.type = (PsiType)aValue;
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.isEnabled();
                }
                case 2: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter;
                }
                case 1: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.getVariableData()[rowIndex].passAsParameter && !(ParameterTablePanel.this.myParameterTypeSelectors[rowIndex].getComponent() instanceof JLabel);
                }
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }

    public static class VariableData {
        public final PsiVariable variable;
        public PsiType type;
        public String name;
        public boolean passAsParameter;

        public VariableData(PsiVariable var) {
            this.variable = var;
            this.type = var.getType();
        }

        public VariableData(PsiVariable var, PsiType type) {
            this.variable = var;
            this.type = type;
        }
    }
}

