/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class CanonicalTypes {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.CanonicalTypes");

    public static Type createTypeWrapper(PsiType type) {
        return (Type)type.accept((PsiTypeVisitor)Creator.INSTANCE);
    }

    private static class Creator
    extends PsiTypeVisitor<Type> {
        public static final Creator INSTANCE = new Creator();

        private Creator() {
        }

        public Type visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return new Primitive(primitiveType);
        }

        public Type visitEllipsisType(PsiEllipsisType ellipsisType) {
            return new Ellipsis((Type)ellipsisType.getComponentType().accept((PsiTypeVisitor)this));
        }

        public Type visitArrayType(PsiArrayType arrayType) {
            return new Array((Type)arrayType.getComponentType().accept((PsiTypeVisitor)this));
        }

        public Type visitWildcardType(PsiWildcardType wildcardType) {
            PsiType wildcardBound = wildcardType.getBound();
            Type bound = wildcardBound == null ? null : (Type)wildcardBound.accept((PsiTypeVisitor)this);
            return new WildcardType(wildcardType.isExtends(), bound);
        }

        public Type visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass instanceof PsiAnonymousClass) {
                return this.visitClassType(((PsiAnonymousClass)aClass).getBaseClassType());
            }
            String originalText = classType.getPresentableText();
            if (aClass == null) {
                return new WrongType(originalText);
            }
            HashMap substMap = new HashMap();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType substType = substitutor.substitute(typeParameter);
                String name = typeParameter.getName();
                if (substType == null) {
                    substMap.put(name, null);
                    continue;
                }
                substMap.put(name, substType.accept((PsiTypeVisitor)this));
            }
            String qualifiedName = aClass.getQualifiedName();
            LOG.assertTrue(aClass.getName() != null);
            return new ClassType(originalText, qualifiedName != null ? qualifiedName : aClass.getName(), (Map)substMap);
        }
    }

    private static class ClassType
    extends Type {
        private final String myOriginalText;
        private final String myClassQName;
        private final Map<String, Type> mySubstitutor;

        private ClassType(String originalText, String classQName, Map<String, Type> substitutor) {
            this.myOriginalText = originalText;
            this.myClassQName = classQName;
            this.mySubstitutor = substitutor;
        }

        @Override
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            PsiResolveHelper resolveHelper = facade.getResolveHelper();
            PsiClass aClass = resolveHelper.resolveReferencedClass(this.myClassQName, context);
            if (aClass == null) {
                return factory.createTypeFromText(this.myClassQName, context);
            }
            HashMap substMap = new HashMap();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                String name = typeParameter.getName();
                Type type = this.mySubstitutor.get(name);
                if (type != null) {
                    substMap.put(typeParameter, type.getType(context, manager));
                    continue;
                }
                substMap.put(typeParameter, null);
            }
            return factory.createType(aClass, factory.createSubstitutor((Map)substMap));
        }

        @Override
        public String getTypeText() {
            return this.myOriginalText;
        }

        @Override
        public void addImportsTo(JavaCodeFragment codeFragment) {
            codeFragment.addImportsFromString(this.myClassQName);
            Collection<Type> types = this.mySubstitutor.values();
            for (Type type : types) {
                if (type == null) continue;
                type.addImportsTo(codeFragment);
            }
        }
    }

    private static class WrongType
    extends Type {
        private final String myText;

        private WrongType(String text) {
            this.myText = text;
        }

        @Override
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            return JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(this.myText, context);
        }

        @Override
        public String getTypeText() {
            return this.myText;
        }

        @Override
        public void addImportsTo(JavaCodeFragment codeFragment) {
        }
    }

    private static class WildcardType
    extends Type {
        private final boolean myIsExtending;
        private final Type myBound;

        private WildcardType(boolean isExtending, Type bound) {
            this.myIsExtending = isExtending;
            this.myBound = bound;
        }

        @Override
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            if (this.myBound == null) {
                return PsiWildcardType.createUnbounded((PsiManager)context.getManager());
            }
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends((PsiManager)context.getManager(), (PsiType)this.myBound.getType(context, manager));
            }
            return PsiWildcardType.createSuper((PsiManager)context.getManager(), (PsiType)this.myBound.getType(context, manager));
        }

        @Override
        public String getTypeText() {
            if (this.myBound == null) {
                return "?";
            }
            return "? " + (this.myIsExtending ? "extends " : "super ") + this.myBound.getTypeText();
        }

        @Override
        public void addImportsTo(JavaCodeFragment codeFragment) {
            if (this.myBound != null) {
                this.myBound.addImportsTo(codeFragment);
            }
        }
    }

    private static class Ellipsis
    extends Type {
        private final Type myComponentType;

        private Ellipsis(Type componentType) {
            this.myComponentType = componentType;
        }

        @Override
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            return new PsiEllipsisType(this.myComponentType.getType(context, manager));
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "...";
        }

        @Override
        public void addImportsTo(JavaCodeFragment codeFragment) {
            this.myComponentType.addImportsTo(codeFragment);
        }
    }

    private static class Array
    extends Type {
        private final Type myComponentType;

        private Array(Type componentType) {
            this.myComponentType = componentType;
        }

        @Override
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            return this.myComponentType.getType(context, manager).createArrayType();
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "[]";
        }

        @Override
        public void addImportsTo(JavaCodeFragment codeFragment) {
            this.myComponentType.addImportsTo(codeFragment);
        }
    }

    private static class Primitive
    extends Type {
        private final PsiPrimitiveType myType;

        private Primitive(PsiPrimitiveType type) {
            this.myType = type;
        }

        @Override
        public PsiType getType(PsiElement context, PsiManager manager) {
            return this.myType;
        }

        @Override
        public String getTypeText() {
            return this.myType.getPresentableText();
        }

        @Override
        public void addImportsTo(JavaCodeFragment codeFragment) {
        }
    }

    public static abstract class Type {
        public abstract PsiType getType(PsiElement var1, PsiManager var2) throws IncorrectOperationException;

        @NonNls
        public abstract String getTypeText();

        public abstract void addImportsTo(JavaCodeFragment var1);
    }
}

