/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.occurences.ExpressionOccurenceManager;
import com.intellij.refactoring.util.occurences.NotInSuperCallOccurenceFilter;
import com.intellij.refactoring.util.occurences.NotInThisCallFilter;
import com.intellij.refactoring.util.occurences.OccurenceFilter;
import com.intellij.refactoring.util.occurences.OccurenceManager;
import org.jetbrains.annotations.NotNull;

public class IntroduceFieldHandler
extends BaseExpressionToFieldHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.field.title");
    private static final MyOccurenceFilter MY_OCCURENCE_FILTER = new MyOccurenceFilter();

    @Override
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Override
    protected boolean validClass(PsiClass parentClass, Editor editor) {
        if (parentClass.isInterface()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.introduce.field.in.interface"));
            CommonRefactoringUtil.showErrorHint((Project)parentClass.getProject(), (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)this.getHelpID());
            return false;
        }
        return true;
    }

    @Override
    protected String getHelpID() {
        return "refactoring.introduceField";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceField/IntroduceFieldHandler.invoke must not be null");
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, "refactoring.introduceField", project, this.getElementProcessor(project, editor));
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr, PsiType type, PsiExpression[] occurences, PsiElement anchorElement, PsiElement anchorElementIfAll) {
        PsiElement ref;
        PsiModifierListOwner staticParentElement;
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class);
        PsiElement element = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT);
        if (element == null) {
            element = expr;
        }
        boolean declareStatic = (staticParentElement = PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)parentClass)) != null;
        boolean isInSuperOrThis = false;
        if (!declareStatic) {
            for (int i = 0; !declareStatic && i < occurences.length; ++i) {
                PsiExpression occurence = occurences[i];
                declareStatic = isInSuperOrThis = IntroduceFieldHandler.isInSuperOrThis(occurence);
            }
        }
        PsiLocalVariable localVariable = null;
        if (expr instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)expr).resolve()) instanceof PsiLocalVariable) {
            localVariable = (PsiLocalVariable)ref;
        }
        int occurencesNumber = occurences.length;
        boolean currentMethodConstructor = containingMethod != null && containingMethod.isConstructor();
        boolean allowInitInMethod = (!currentMethodConstructor || !isInSuperOrThis) && anchorElement instanceof PsiStatement;
        boolean allowInitInMethodIfAll = (!currentMethodConstructor || !isInSuperOrThis) && anchorElementIfAll instanceof PsiStatement;
        IntroduceFieldDialog dialog = new IntroduceFieldDialog(project, parentClass, expr, localVariable, currentMethodConstructor, false, declareStatic, occurencesNumber, allowInitInMethod, allowInitInMethodIfAll, new TypeSelectorManagerImpl(project, type, expr, occurences));
        dialog.show();
        if (!dialog.isOK()) {
            if (occurencesNumber > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        if (!dialog.isDeleteVariable()) {
            localVariable = null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), dialog.isReplaceAllOccurrences(), declareStatic, dialog.isDeclareFinal(), dialog.getInitializerPlace(), dialog.getFieldVisibility(), localVariable, dialog.getFieldType(), localVariable != null, (BaseExpressionToFieldHandler.TargetDestination)null, false, false);
    }

    private static boolean isInSuperOrThis(PsiExpression occurence) {
        return !NotInSuperCallOccurenceFilter.INSTANCE.isOK(occurence) || !NotInThisCallFilter.INSTANCE.isOK(occurence);
    }

    @Override
    protected OccurenceManager createOccurenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        MyOccurenceFilter occurenceFilter = IntroduceFieldHandler.isInSuperOrThis(selectedExpr) ? null : MY_OCCURENCE_FILTER;
        return new ExpressionOccurenceManager(selectedExpr, (PsiElement)parentClass, occurenceFilter, true);
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, false);
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    private static class MyOccurenceFilter
    implements OccurenceFilter {
        private MyOccurenceFilter() {
        }

        @Override
        public boolean isOK(PsiExpression occurence) {
            return !IntroduceFieldHandler.isInSuperOrThis(occurence);
        }
    }
}

