/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.TestUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurences.OccurenceManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExpressionToFieldHandler
extends IntroduceHandlerBase
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler");
    private PsiClass myParentClass;

    @Override
    protected boolean invokeImpl(final Project project, final @NotNull PsiExpression selectedExpr, final Editor editor) {
        PsiStatement statement;
        PsiElement tempAnchorElement;
        Settings settings;
        if (selectedExpr == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler.invokeImpl must not be null");
        }
        final PsiElement element = BaseExpressionToFieldHandler.getPhysicalElement(selectedExpr);
        PsiFile file = element.getContainingFile();
        LOG.assertTrue(file != null, (Object)"expr.getContainingFile() == null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + selectedExpr);
        }
        this.myParentClass = this.getParentClass(selectedExpr);
        if (this.myParentClass == null) {
            if (JspPsiUtil.isInJspFile((PsiElement)file)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{this.getRefactoringName()}), (String)this.getRefactoringName(), (String)this.getHelpID());
                return false;
            }
            LOG.assertTrue(false);
            return false;
        }
        if (!this.validClass(this.myParentClass, editor)) {
            return false;
        }
        PsiType tempType = BaseExpressionToFieldHandler.getTypeByExpression(selectedExpr);
        if (tempType == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"unknown.expression.type"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        if (PsiType.VOID.equals(tempType)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return false;
        }
        PsiClass parentClass = this.myParentClass;
        final OccurenceManager occurenceManager = this.createOccurenceManager(selectedExpr, parentClass);
        final PsiExpression[] occurrences = occurenceManager.getOccurences();
        final PsiElement anchorStatementIfAll = occurenceManager.getAnchorStatementForAll();
        List<RangeHighlighter> highlighters = null;
        if (editor != null) {
            highlighters = RefactoringUtil.highlightAllOccurences(project, (PsiElement[])occurrences, editor);
        }
        if ((settings = this.showRefactoringDialog(project, editor, this.myParentClass, selectedExpr, tempType, occurrences, tempAnchorElement = RefactoringUtil.getParentExpressionAnchorElement((PsiElement)selectedExpr), anchorStatementIfAll)) == null) {
            return false;
        }
        if (settings.getForcedType() != null) {
            tempType = settings.getForcedType();
        }
        final PsiType type = tempType;
        final String fieldName = settings.getFieldName();
        final PsiElement anchorElementIfOne = tempAnchorElement;
        final boolean replaceAll = settings.isReplaceAll();
        if (replaceAll) {
            tempAnchorElement = anchorStatementIfAll;
        }
        final PsiElement anchorElement = tempAnchorElement;
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter highlighter : highlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
        PsiElement anchor = BaseExpressionToFieldHandler.getNormalizedAnchor(anchorElement);
        boolean tempDeleteSelf = false;
        if (element.getParent() instanceof PsiExpressionStatement && anchor.equals(anchorElement) && (statement = (PsiStatement)element.getParent()).getParent() instanceof PsiCodeBlock) {
            tempDeleteSelf = true;
        }
        final boolean deleteSelf = tempDeleteSelf;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PsiClass destClass;
                    PsiExpression expr = selectedExpr;
                    InitializationPlace initializerPlace = settings.getInitializerPlace();
                    PsiLocalVariable localVariable = settings.getLocalVariable();
                    boolean deleteLocalVariable = settings.isDeleteLocalVariable();
                    PsiExpression initializer = localVariable != null ? localVariable.getInitializer() : expr;
                    PsiMethod enclosingConstructor = BaseExpressionToFieldHandler.getEnclosingConstructor(BaseExpressionToFieldHandler.this.myParentClass, anchorElement);
                    PsiClass psiClass = destClass = settings.getDestinationClass() == null ? BaseExpressionToFieldHandler.this.myParentClass : settings.getDestinationClass();
                    if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)destClass.getContainingFile())) {
                        return;
                    }
                    ChangeContextUtil.encodeContextInfo((PsiElement)initializer, true);
                    PsiEnumConstant field = settings.isIntroduceEnumConstant() ? EnumConstantsUtil.createEnumConstant(destClass, fieldName, initializer) : BaseExpressionToFieldHandler.this.createField(fieldName, type, initializer, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION && initializer != null);
                    PsiElement finalAnchorElement = null;
                    if (destClass == BaseExpressionToFieldHandler.this.myParentClass) {
                        for (finalAnchorElement = anchorElement; finalAnchorElement != null && finalAnchorElement.getParent() != destClass; finalAnchorElement = finalAnchorElement.getParent()) {
                        }
                    }
                    PsiMember anchorMember = finalAnchorElement instanceof PsiMember ? (PsiMember)finalAnchorElement : null;
                    BaseExpressionToFieldHandler.setModifiers((PsiField)field, settings, settings.isDeclareStatic(), occurrences);
                    if (anchorMember instanceof PsiField && anchorMember.hasModifierProperty("static") == field.hasModifierProperty("static")) {
                        field = (PsiField)destClass.addBefore((PsiElement)field, (PsiElement)anchorMember);
                    } else if (anchorMember instanceof PsiClassInitializer) {
                        field = (PsiField)destClass.addBefore((PsiElement)field, (PsiElement)anchorMember);
                        destClass.addBefore(CodeEditUtil.createLineFeed(field.getManager()), (PsiElement)anchorMember);
                    } else {
                        field = (PsiField)destClass.add((PsiElement)field);
                    }
                    if (!settings.isIntroduceEnumConstant()) {
                        VisibilityUtil.fixVisibility((PsiExpression[])occurrences, (PsiMember)field, (String)settings.getFieldVisibility());
                    }
                    PsiStatement assignStatement = null;
                    PsiElement anchorElementHere = null;
                    if (initializerPlace == InitializationPlace.IN_CURRENT_METHOD && initializer != null || initializerPlace == InitializationPlace.IN_CONSTRUCTOR && enclosingConstructor != null && initializer != null) {
                        PsiElement anchorInConstructor;
                        anchorElementHere = replaceAll ? (enclosingConstructor != null ? ((anchorInConstructor = occurenceManager.getAnchorStatementForAllInScope((PsiElement)enclosingConstructor)) != null ? anchorInConstructor : anchorStatementIfAll) : anchorStatementIfAll) : anchorElementIfOne;
                        assignStatement = BaseExpressionToFieldHandler.this.createAssignment((PsiField)field, initializer, anchorElementHere);
                        if (!IntroduceVariableBase.isLoopOrIf(anchorElementHere.getParent())) {
                            anchorElementHere.getParent().addBefore((PsiElement)assignStatement, BaseExpressionToFieldHandler.getNormalizedAnchor(anchorElementHere));
                        }
                    }
                    if (initializerPlace == InitializationPlace.IN_CONSTRUCTOR && initializer != null) {
                        BaseExpressionToFieldHandler.this.addInitializationToConstructors(initializer, (PsiField)field, enclosingConstructor);
                    }
                    if (initializerPlace == InitializationPlace.IN_SETUP_METHOD && initializer != null) {
                        BaseExpressionToFieldHandler.this.addInitializationToSetUp(initializer, (PsiField)field, occurenceManager, replaceAll);
                    }
                    if (expr.getParent() instanceof PsiParenthesizedExpression) {
                        expr = (PsiExpression)expr.getParent();
                    }
                    if (deleteSelf) {
                        element.getParent().delete();
                    }
                    if (replaceAll) {
                        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
                        for (PsiExpression occurrence : occurrences) {
                            PsiElement replaced;
                            if (occurrence instanceof PsiExpression) {
                                occurrence = RefactoringUtil.outermostParenthesizedExpression(occurrence);
                            }
                            if (deleteSelf && occurrence.equals(expr) || (replaced = RefactoringUtil.replaceOccurenceWithFieldRef(occurrence, (PsiField)field, destClass)) == null) continue;
                            array.add(replaced);
                        }
                        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                            PsiElement[] exprsToHighlight = array.toArray(new PsiElement[array.size()]);
                            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                            highlightManager.addOccurrenceHighlights(editor, exprsToHighlight, BaseExpressionToFieldHandler.highlightAttributes(), true, null);
                            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                        }
                    } else if (!deleteSelf) {
                        expr = RefactoringUtil.outermostParenthesizedExpression(expr);
                        RefactoringUtil.replaceOccurenceWithFieldRef(expr, (PsiField)field, destClass);
                    }
                    if (anchorElementHere != null && IntroduceVariableBase.isLoopOrIf(anchorElementHere.getParent())) {
                        IntroduceVariableBase.putStatementInLoopBody(assignStatement, anchorElementHere.getParent(), anchorElementHere);
                    }
                    if (localVariable != null && deleteLocalVariable) {
                        localVariable.normalizeDeclaration();
                        localVariable.getParent().delete();
                    }
                    ChangeContextUtil.clearContextInfo((PsiElement)initializer);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, this.getRefactoringName(), null);
        return true;
    }

    public static void setModifiers(PsiField field, Settings settings, boolean declareStatic, PsiExpression[] occurrences) {
        if (!settings.isIntroduceEnumConstant()) {
            if (declareStatic) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            }
            if (settings.isDeclareFinal()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            }
            if (settings.isAnnotateAsNonNls()) {
                PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)field.getProject()).getElementFactory().createAnnotationFromText("@org.jetbrains.annotations.NonNls", (PsiElement)field);
                PsiModifierList modifierList = field.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.addAfter((PsiElement)annotation, null);
            }
        }
        JavaCodeStyleManager.getInstance((Project)field.getProject()).shortenClassReferences((PsiElement)field);
    }

    private static PsiElement getPhysicalElement(PsiExpression selectedExpr) {
        PsiElement element = (PsiElement)selectedExpr.getUserData(ElementToWorkOn.PARENT);
        if (element == null) {
            element = selectedExpr;
        }
        return element;
    }

    private static TextAttributes highlightAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    protected abstract OccurenceManager createOccurenceManager(PsiExpression var1, PsiClass var2);

    protected final PsiClass getParentClass() {
        return this.myParentClass;
    }

    protected abstract boolean validClass(PsiClass var1, Editor var2);

    protected boolean isStaticField() {
        return false;
    }

    private static PsiElement getNormalizedAnchor(PsiElement anchorElement) {
        PsiElement prev;
        PsiElement child = anchorElement;
        while (!(child == null || RefactoringUtil.isExpressionAnchorElement(prev = child.getPrevSibling()) || prev instanceof PsiJavaToken && ((PsiJavaToken)prev).getTokenType() == JavaTokenType.LBRACE)) {
            child = prev;
        }
        PsiElement anchor = (child = PsiTreeUtil.skipSiblingsForward((PsiElement)child, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null ? child : anchorElement;
        return anchor;
    }

    protected abstract String getHelpID();

    protected abstract Settings showRefactoringDialog(Project var1, Editor var2, PsiClass var3, PsiExpression var4, PsiType var5, PsiExpression[] var6, PsiElement var7, PsiElement var8);

    private static PsiType getTypeByExpression(PsiExpression expr) {
        return RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
    }

    public PsiClass getParentClass(PsiExpression initializerExpression) {
        PsiElement element = (PsiElement)initializerExpression.getUserData(ElementToWorkOn.PARENT);
        if (element == null) {
            element = initializerExpression.getParent();
        }
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || parent instanceof PsiAnonymousClass) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    public static PsiMethod getEnclosingConstructor(PsiClass parentClass, PsiElement element) {
        PsiMethod[] constructors;
        if (element == null) {
            return null;
        }
        for (PsiMethod constructor : constructors = parentClass.getConstructors()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)element, (boolean)false)) continue;
            return constructor;
        }
        return null;
    }

    private void addInitializationToSetUp(PsiExpression initializer, PsiField field, OccurenceManager occurenceManager, boolean replaceAll) throws IncorrectOperationException {
        PsiExpressionStatement expressionStatement;
        PsiAssignmentExpression expr;
        PsiExpression rExpression;
        PsiMethod setupMethod = TestUtil.findSetUpMethod((PsiClass)this.myParentClass);
        assert (setupMethod != null);
        PsiElement anchor = null;
        if (PsiTreeUtil.isAncestor((PsiElement)setupMethod, (PsiElement)initializer, (boolean)true)) {
            anchor = replaceAll ? occurenceManager.getAnchorStatementForAllInScope((PsiElement)setupMethod) : PsiTreeUtil.getParentOfType((PsiElement)initializer, PsiStatement.class);
        }
        LOG.assertTrue((rExpression = (expr = (PsiAssignmentExpression)(expressionStatement = (PsiExpressionStatement)JavaPsiFacade.getInstance((Project)this.myParentClass.getProject()).getElementFactory().createStatementFromText(field.getName() + "= expr;", null)).getExpression()).getRExpression()) != null);
        rExpression.replace((PsiElement)initializer);
        PsiCodeBlock body = setupMethod.getBody();
        assert (body != null);
        body.addBefore((PsiElement)expressionStatement, anchor);
    }

    private void addInitializationToConstructors(PsiExpression initializerExpression, PsiField field, PsiMethod enclosingConstructor) {
        try {
            PsiClass aClass = field.getContainingClass();
            PsiMethod[] constructors = aClass.getConstructors();
            boolean added = false;
            for (PsiMethod constructor : constructors) {
                String text;
                PsiExpression expression;
                PsiStatement first;
                PsiStatement[] statements;
                PsiCodeBlock body;
                if (constructor == enclosingConstructor || (body = constructor.getBody()) == null || (statements = body.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText())) continue;
                PsiStatement assignment = this.createAssignment(field, initializerExpression, body.getLastChild());
                assignment = (PsiStatement)body.add((PsiElement)assignment);
                ChangeContextUtil.decodeContextInfo((PsiElement)assignment, field.getContainingClass(), (PsiExpression)RefactoringUtil.createThisExpression(field.getManager(), null));
                added = true;
            }
            if (!added && enclosingConstructor == null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)field.getProject()).getElementFactory();
                PsiMethod constructor = (PsiMethod)aClass.add((PsiElement)factory.createConstructor());
                PsiCodeBlock body = constructor.getBody();
                PsiStatement assignment = this.createAssignment(field, initializerExpression, body.getLastChild());
                assignment = (PsiStatement)body.add((PsiElement)assignment);
                ChangeContextUtil.decodeContextInfo((PsiElement)assignment, field.getContainingClass(), (PsiExpression)RefactoringUtil.createThisExpression(field.getManager(), null));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiField createField(String fieldName, PsiType type, PsiExpression initializerExpr, boolean includeInitializer) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("private int ");
        pattern.append(fieldName);
        if (includeInitializer) {
            pattern.append("=0");
        }
        pattern.append(";");
        PsiManager psiManager = this.myParentClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        try {
            PsiField field = factory.createFieldFromText(pattern.toString(), null);
            field = (PsiField)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)field);
            field.getTypeElement().replace((PsiElement)factory.createTypeElement(type));
            if (includeInitializer) {
                field.getInitializer().replace((PsiElement)initializerExpr);
            }
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiStatement createAssignment(PsiField field, PsiExpression initializerExpr, PsiElement context) {
        try {
            String pattern = "x=0;";
            PsiManager psiManager = this.myParentClass.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)statement);
            PsiAssignmentExpression expr = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression rExpression = expr.getRExpression();
            LOG.assertTrue(rExpression != null);
            rExpression.replace((PsiElement)initializerExpr);
            PsiReferenceExpression fieldReference = RenameJavaVariableProcessor.createMemberReference((PsiMember)field, context);
            expr.getLExpression().replace((PsiElement)fieldReference);
            return statement;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected Pass<ElementToWorkOn> getElementProcessor(final Project project, final Editor editor) {
        return new Pass<ElementToWorkOn>(){

            public void pass(ElementToWorkOn elementToWorkOn) {
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getExpression() == null) {
                    PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
                    boolean result = BaseExpressionToFieldHandler.this.invokeImpl(project, localVariable, editor);
                    if (result) {
                        editor.getSelectionModel().removeSelection();
                    }
                } else if (BaseExpressionToFieldHandler.this.invokeImpl(project, elementToWorkOn.getExpression(), editor)) {
                    editor.getSelectionModel().removeSelection();
                }
            }
        };
    }

    protected abstract String getRefactoringName();

    public static class TargetDestination {
        private final String myQualifiedName;
        private final Project myProject;
        private PsiClass myParentClass;
        private PsiClass myTargetClass;

        public TargetDestination(String qualifiedName, PsiClass parentClass) {
            this.myQualifiedName = qualifiedName;
            this.myParentClass = parentClass;
            this.myProject = parentClass.getProject();
        }

        public TargetDestination(@NotNull PsiClass targetClass) {
            if (targetClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$TargetDestination.<init> must not be null");
            }
            this.myTargetClass = targetClass;
            this.myQualifiedName = targetClass.getQualifiedName();
            this.myProject = targetClass.getProject();
        }

        @Nullable
        public PsiClass getTargetClass() {
            PsiDirectory[] directories;
            if (this.myTargetClass != null) {
                return this.myTargetClass;
            }
            String packageName = StringUtil.getPackageName((String)this.myQualifiedName);
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            PsiDirectory psiDirectory = psiPackage != null ? ((directories = psiPackage.getDirectories(GlobalSearchScope.allScope((Project)this.myProject))).length > 1 ? DirectoryChooserUtil.chooseDirectory(directories, null, this.myProject, new HashMap<PsiDirectory, String>()) : directories[0]) : PackageUtil.findOrCreateDirectoryForPackage(this.myProject, packageName, this.myParentClass.getContainingFile().getContainingDirectory(), false);
            String shortName = StringUtil.getShortName((String)this.myQualifiedName);
            this.myTargetClass = psiDirectory != null ? JavaDirectoryService.getInstance().createClass(psiDirectory, shortName) : null;
            return this.myTargetClass;
        }
    }

    public static class Settings {
        private final String myFieldName;
        private final PsiType myForcedType;
        private final boolean myReplaceAll;
        private final boolean myDeclareStatic;
        private final boolean myDeclareFinal;
        private final InitializationPlace myInitializerPlace;
        private final String myVisibility;
        private final boolean myDeleteLocalVariable;
        private final TargetDestination myTargetClass;
        private final boolean myAnnotateAsNonNls;
        private final boolean myIntroduceEnumConstant;
        private final PsiLocalVariable myLocalVariable;

        public PsiLocalVariable getLocalVariable() {
            return this.myLocalVariable;
        }

        public boolean isDeleteLocalVariable() {
            return this.myDeleteLocalVariable;
        }

        public String getFieldName() {
            return this.myFieldName;
        }

        public boolean isDeclareStatic() {
            return this.myDeclareStatic;
        }

        public boolean isDeclareFinal() {
            return this.myDeclareFinal;
        }

        public InitializationPlace getInitializerPlace() {
            return this.myInitializerPlace;
        }

        public String getFieldVisibility() {
            return this.myVisibility;
        }

        @Nullable
        public PsiClass getDestinationClass() {
            return this.myTargetClass != null ? this.myTargetClass.getTargetClass() : null;
        }

        public PsiType getForcedType() {
            return this.myForcedType;
        }

        public boolean isReplaceAll() {
            return this.myReplaceAll;
        }

        public boolean isAnnotateAsNonNls() {
            return this.myAnnotateAsNonNls;
        }

        public boolean isIntroduceEnumConstant() {
            return this.myIntroduceEnumConstant;
        }

        public Settings(String fieldName, boolean replaceAll, boolean declareStatic, boolean declareFinal, InitializationPlace initializerPlace, String visibility, PsiLocalVariable localVariableToRemove, PsiType forcedType, boolean deleteLocalVariable, TargetDestination targetDestination, boolean annotateAsNonNls, boolean introduceEnumConstant) {
            this.myFieldName = fieldName;
            this.myReplaceAll = replaceAll;
            this.myDeclareStatic = declareStatic;
            this.myDeclareFinal = declareFinal;
            this.myInitializerPlace = initializerPlace;
            this.myVisibility = visibility;
            this.myLocalVariable = localVariableToRemove;
            this.myDeleteLocalVariable = deleteLocalVariable;
            this.myForcedType = forcedType;
            this.myTargetClass = targetDestination;
            this.myAnnotateAsNonNls = annotateAsNonNls;
            this.myIntroduceEnumConstant = introduceEnumConstant;
        }

        public Settings(String fieldName, boolean replaceAll, boolean declareStatic, boolean declareFinal, InitializationPlace initializerPlace, @Modifier String visibility, PsiLocalVariable localVariableToRemove, PsiType forcedType, boolean deleteLocalVariable, PsiClass targetClass, boolean annotateAsNonNls, boolean introduceEnumConstant) {
            this(fieldName, replaceAll, declareStatic, declareFinal, initializerPlace, visibility, localVariableToRemove, forcedType, deleteLocalVariable, new TargetDestination(targetClass), annotateAsNonNls, introduceEnumConstant);
        }
    }

    public static enum InitializationPlace {
        IN_CURRENT_METHOD,
        IN_FIELD_DECLARATION,
        IN_CONSTRUCTOR,
        IN_SETUP_METHOD;

    }
}

