/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.inline.InlineToAnonymousClassProcessor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class InlineToAnonymousClassDialog
extends InlineOptionsDialog {
    private final PsiClass myClass;
    private final PsiCall myCallToInline;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurences;

    protected InlineToAnonymousClassDialog(Project project, PsiClass psiClass, PsiCall callToInline, boolean isInvokeOnReference) {
        super(project, true, (PsiElement)psiClass);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInvokedOnReference = isInvokeOnReference;
        this.setTitle(RefactoringBundle.message((String)"inline.to.anonymous.refactoring"));
        this.init();
    }

    @Override
    protected String getNameLabelText() {
        String className = PsiFormatUtil.formatClass((PsiClass)this.myClass, (int)1);
        return RefactoringBundle.message((String)"inline.to.anonymous.name.label", (Object[])new Object[]{className});
    }

    @Override
    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.to.anonymous.border.title");
    }

    @Override
    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.the.class");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.class");
    }

    @Override
    protected boolean isInlineThis() {
        return false;
    }

    @Override
    protected JComponent createCenterPanel() {
        JComponent optionsPanel = super.createCenterPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)optionsPanel, gbc);
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        this.myCbSearchInComments = new JCheckBox(RefactoringBundle.message((String)"search.in.comments.and.strings"), settings.INLINE_CLASS_SEARCH_IN_COMMENTS);
        this.myCbSearchTextOccurences = new JCheckBox(RefactoringBundle.message((String)"search.for.text.occurrences"), settings.INLINE_CLASS_SEARCH_IN_NON_JAVA);
        gbc.gridy = 1;
        panel.add((Component)this.myCbSearchInComments, gbc);
        gbc.gridy = 2;
        panel.add((Component)this.myCbSearchTextOccurences, gbc);
        return panel;
    }

    @Override
    protected void doAction() {
        boolean searchInComments = this.myCbSearchInComments.isSelected();
        boolean searchInNonJava = this.myCbSearchTextOccurences.isSelected();
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.INLINE_CLASS_SEARCH_IN_COMMENTS = searchInComments;
        settings.INLINE_CLASS_SEARCH_IN_NON_JAVA = searchInNonJava;
        this.invokeRefactoring(new InlineToAnonymousClassProcessor(this.getProject(), this.myClass, this.myCallToInline, this.isInlineThisOnly(), searchInComments, searchInNonJava));
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.inlineClass");
    }
}

