/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.usageView.UsageInfo;

public class MethodCallUsageInfo
extends UsageInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.MethodCallUsageInfo");
    private final boolean myToChangeArguments;
    private final boolean myToCatchExceptions;
    private final PsiMethod myReferencedMethod;

    public boolean isToCatchExceptions() {
        return this.myToCatchExceptions;
    }

    public boolean isToChangeArguments() {
        return this.myToChangeArguments;
    }

    public MethodCallUsageInfo(PsiElement ref, boolean isToChangeArguments, boolean isToCatchExceptions) {
        super(ref);
        this.myToChangeArguments = isToChangeArguments;
        this.myToCatchExceptions = isToCatchExceptions;
        this.myReferencedMethod = MethodCallUsageInfo.resolveMethod(ref);
    }

    private static PsiMethod resolveMethod(PsiElement ref) {
        if (ref instanceof PsiEnumConstant) {
            return ((PsiEnumConstant)ref).resolveConstructor();
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiCall) {
            return ((PsiCall)parent).resolveMethod();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiNewExpression)parent.getParent()).resolveConstructor();
        }
        LOG.error("Unknown reference");
        return null;
    }

    public PsiMethod getReferencedMethod() {
        return this.myReferencedMethod;
    }
}

