/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SamePsiMemberWeigher
extends ProximityWeigher {
    @Override
    public Comparable weigh(@NotNull PsiElement element, ProximityLocation location) {
        PsiMember member;
        PsiFile file;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/proximity/SamePsiMemberWeigher.weigh must not be null");
        }
        PsiElement position = location.getPosition();
        if (!position.isPhysical() && element.isPhysical() && (file = position.getContainingFile()) != null) {
            int offset;
            PsiFile originalFile = file.getOriginalFile();
            PsiElement candidate = originalFile.findElementAt(offset = position.getTextRange().getStartOffset());
            if (candidate == null) {
                candidate = originalFile.findElementAt(offset - 1);
            }
            if (candidate != null) {
                position = candidate;
            }
        }
        if ((member = (PsiMember)PsiTreeUtil.getContextOfType((PsiElement)PsiTreeUtil.findCommonContext((PsiElement)position, (PsiElement)element), PsiMember.class, (boolean)false)) instanceof PsiClass) {
            return Integer.valueOf(1);
        }
        if (member != null) {
            return Integer.valueOf(2);
        }
        return Integer.valueOf(0);
    }
}

