/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    public static String getNameForClass(@NotNull PsiClass aClass, boolean qualified) {
        String qName;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/presentation/java/ClassPresentationUtil.getNameForClass must not be null");
        }
        if (aClass instanceof PsiAnonymousClass) {
            if (aClass instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass).getEnumConstant();
                String name = enumConstant.getName();
                return PsiBundle.message((String)"enum.constant.context", (Object[])new Object[]{name, ClassPresentationUtil.getContextName((PsiElement)enumConstant, qualified)});
            }
            return PsiBundle.message((String)"anonymous.class.context.display", (Object[])new Object[]{ClassPresentationUtil.getContextName((PsiElement)aClass, qualified)});
        }
        if (qualified && (qName = aClass.getQualifiedName()) != null) {
            return qName;
        }
        String className = aClass.getName();
        String contextName = ClassPresentationUtil.getContextName((PsiElement)aClass, qualified);
        return contextName != null ? PsiBundle.message((String)"class.context.display", (Object[])new Object[]{className, contextName}) : className;
    }

    private static String getNameForElement(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/presentation/java/ClassPresentationUtil.getNameForElement must not be null");
        }
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, qualified);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            return PsiBundle.message((String)"method.context.display", (Object[])new Object[]{methodName, ClassPresentationUtil.getContextName((PsiElement)method, qualified)});
        }
        if (element instanceof PsiClassOwner) {
            return null;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getName();
        }
        return null;
    }

    private static String getContextName(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/presentation/java/ClassPresentationUtil.getContextName must not be null");
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        while (parent != null) {
            String name = ClassPresentationUtil.getNameForElement(parent, qualified);
            if (name != null) {
                return name;
            }
            if (parent instanceof PsiFile) {
                return null;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static ItemPresentation getPresentation(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/presentation/java/ClassPresentationUtil.getPresentation must not be null");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return null;
        }
        return new ItemPresentation(){

            public String getPresentableText() {
                return ClassPresentationUtil.getNameForClass(psiClass, false);
            }

            public String getLocationString() {
                PsiFile file = psiClass.getContainingFile();
                if (file instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)file;
                    String packageName = classOwner.getPackageName();
                    if (packageName.length() == 0) {
                        return null;
                    }
                    return "(" + packageName + ")";
                }
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                if (psiClass.isDeprecated()) {
                    return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                }
                return null;
            }

            public Icon getIcon(boolean open) {
                return psiClass.getIcon(3);
            }
        };
    }
}

