/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.parsing.ExpressionParsing;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeCopyHandler;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeUtilSupport
implements TreeGenerator,
TreeCopyHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaTreeGenerator");
    private static final Key<Boolean> ALREADY_ESCAPED;
    private static final Key<Boolean> ESCAPEMENT_ENGAGED;
    private static final Key<PsiClass> REFERENCED_CLASS_KEY;
    private static final Key<PsiMember> REFERENCED_MEMBER_KEY;
    private static final Key<Boolean> INTERFACE_MODIFIERS_FLAG_KEY;

    public static void setup() {
    }

    @Override
    @Nullable
    public TreeElement generateTreeFor(PsiElement original, CharTable table, PsiManager manager) {
        if (original instanceof PsiKeyword || original instanceof PsiIdentifier) {
            String text = original.getText();
            return JavaChangeUtilSupport.createLeafFromText(text, table, manager, original, ((PsiJavaToken)original).getTokenType());
        }
        if (original instanceof PsiModifierList) {
            String text = original.getText();
            assert (text != null) : "Text is null for " + original + "; " + original.getClass();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)original);
            JavaLexer lexer = new JavaLexer(languageLevel);
            lexer.start(text);
            CompositeElement modifierListElement = new JavaParsingContext(table, languageLevel).getDeclarationParsing().parseModifierList((Lexer)lexer);
            if (CodeEditUtil.isNodeGenerated(original.getNode())) {
                ((TreeElement)modifierListElement).acceptTree(new GeneratedMarkerVisitor());
            }
            return modifierListElement;
        }
        if (original instanceof PsiReferenceExpression) {
            TreeElement element = JavaChangeUtilSupport.createReferenceExpression(original.getManager(), original.getText(), table);
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            if (refElement instanceof PsiClass) {
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
            }
            return element;
        }
        if (original instanceof PsiJavaCodeReferenceElement) {
            boolean generated;
            PsiElement refElement = ((PsiJavaCodeReferenceElement)original).resolve();
            boolean bl = generated = refElement != null && CodeEditUtil.isNodeGenerated(refElement.getNode());
            if (refElement instanceof PsiClass) {
                if (refElement instanceof PsiAnonymousClass) {
                    PsiJavaCodeReferenceElement ref = ((PsiAnonymousClass)refElement).getBaseClassReference();
                    original = ref;
                    refElement = ref.resolve();
                }
                boolean isFQ = false;
                if (original instanceof PsiJavaCodeReferenceElementImpl) {
                    int kind = ((PsiJavaCodeReferenceElementImpl)original).getKind();
                    switch (kind) {
                        case 1: 
                        case 3: 
                        case 6: {
                            isFQ = false;
                            break;
                        }
                        case 4: 
                        case 5: {
                            isFQ = true;
                            break;
                        }
                        default: {
                            LOG.assertTrue(false);
                        }
                    }
                }
                String text = isFQ ? ((PsiClass)refElement).getQualifiedName() : original.getText();
                CompositeElement element = JavaChangeUtilSupport.createReference(original.getManager(), text, table, generated);
                element.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)refElement);
                return element;
            }
            return JavaChangeUtilSupport.createReference(original.getManager(), original.getText(), table, generated);
        }
        if (original instanceof PsiCompiledElement) {
            PsiElement sourceVersion = original.getNavigationElement();
            if (sourceVersion != original) {
                return ChangeUtil.generateTreeElement(sourceVersion, table, manager);
            }
            ASTNode mirror = SourceTreeToPsiMap.psiElementToTree(((PsiCompiledElement)original).getMirror());
            return ChangeUtil.generateTreeElement(SourceTreeToPsiMap.treeElementToPsi(mirror), table, manager);
        }
        if (original instanceof PsiTypeElement) {
            PsiJavaCodeReferenceElement ref;
            boolean generated = CodeEditUtil.isNodeGenerated(original.getNode());
            PsiTypeElement typeElement = (PsiTypeElement)original;
            PsiType type = typeElement.getType();
            if (type instanceof PsiEllipsisType) {
                TreeElement componentTypeCopy = ChangeUtil.generateTreeElement(new LightTypeElement(original.getManager(), ((PsiEllipsisType)type).getComponentType()), table, manager);
                if (componentTypeCopy == null) {
                    return null;
                }
                CompositeElement element = ASTFactory.composite(JavaElementType.TYPE);
                CodeEditUtil.setNodeGenerated(element, generated);
                element.rawAddChildren(componentTypeCopy);
                element.rawAddChildren(JavaChangeUtilSupport.createLeafFromText("...", table, manager, original, JavaTokenType.ELLIPSIS));
                return element;
            }
            if (type instanceof PsiArrayType) {
                TreeElement componentTypeCopy = ChangeUtil.generateTreeElement(new LightTypeElement(original.getManager(), ((PsiArrayType)type).getComponentType()), table, manager);
                if (componentTypeCopy == null) {
                    return null;
                }
                CompositeElement element = ASTFactory.composite(JavaElementType.TYPE);
                CodeEditUtil.setNodeGenerated(element, generated);
                element.rawAddChildren(componentTypeCopy);
                element.rawAddChildren(JavaChangeUtilSupport.createLeafFromText("[", table, manager, original, JavaTokenType.LBRACKET));
                element.rawAddChildren(JavaChangeUtilSupport.createLeafFromText("]", table, manager, original, JavaTokenType.RBRACKET));
                return element;
            }
            if (type instanceof PsiPrimitiveType) {
                String text = typeElement.getText();
                if (text.equals("null")) {
                    return null;
                }
                JavaLexer lexer = new JavaLexer(LanguageLevel.JDK_1_3);
                lexer.start(text);
                TreeElement keyword = ParseUtil.createTokenElement((Lexer)lexer, table);
                CodeEditUtil.setNodeGenerated(keyword, generated);
                CompositeElement element = ASTFactory.composite(JavaElementType.TYPE);
                CodeEditUtil.setNodeGenerated(element, generated);
                element.rawAddChildren(keyword);
                return element;
            }
            if (type instanceof PsiWildcardType) {
                String originalText = original.getText();
                CompositeElement element = Parsing.parseTypeText(original.getManager(), originalText, 0, originalText.length(), table);
                if (generated) {
                    element.getTreeParent().acceptTree(new GeneratedMarkerVisitor());
                }
                return element;
            }
            if (type instanceof PsiIntersectionType) {
                PsiIntersectionType intersectionType = (PsiIntersectionType)type;
                LightTypeElement te = new LightTypeElement(original.getManager(), intersectionType.getConjuncts()[0]);
                return ChangeUtil.generateTreeElement(te, table, manager);
            }
            PsiClassType classType = (PsiClassType)type;
            FileElement holderElement = DummyHolderFactory.createHolder(manager, original).getTreeElement();
            String text = classType.getPresentableText();
            CompositeElement fromT = Parsing.parseTypeText(manager, text, 0, text.length(), holderElement.getCharTable());
            holderElement.rawAddChildren(fromT);
            PsiTypeElementImpl result = (PsiTypeElementImpl)SourceTreeToPsiMap.treeElementToPsi(fromT);
            CodeEditUtil.setNodeGenerated(result, generated);
            if (generated && (ref = result.getInnermostComponentReferenceElement()) != null) {
                ((CompositeElement)ref.getNode()).acceptTree(new GeneratedMarkerVisitor());
            }
            JavaChangeUtilSupport.encodeInfoInTypeElement(result, (PsiType)classType);
            return result;
        }
        return null;
    }

    private static LeafElement createLeafFromText(String text, CharTable table, PsiManager manager, PsiElement original, IElementType type) {
        return Factory.createSingleLeafElement(type, (CharSequence)text, 0, text.length(), table, manager, CodeEditUtil.isNodeGenerated(original.getNode()));
    }

    private static CompositeElement createReference(PsiManager manager, String text, CharTable table, boolean generatedFlag) {
        CompositeElement element = Parsing.parseJavaCodeReferenceText(manager, text, table);
        if (element == null) {
            throw new IllegalArgumentException("Failed to create reference element from text '" + text + "'");
        }
        if (generatedFlag) {
            element.acceptTree(new GeneratedMarkerVisitor());
        }
        return element;
    }

    private static TreeElement createReferenceExpression(PsiManager manager, String text, CharTable table) {
        return ExpressionParsing.parseExpressionText(manager, text, 0, text.length(), table);
    }

    @Override
    public TreeElement decodeInformation(TreeElement element, Map<Object, Object> decodingState) {
        String escaped;
        String original;
        boolean shallDecodeEscapedTexts = JavaChangeUtilSupport.shallEncodeEscapedTexts(element, decodingState);
        if (element instanceof CompositeElement) {
            if (element.getElementType() == JavaElementType.JAVA_CODE_REFERENCE || element.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(element);
                PsiClass refClass = (PsiClass)element.getCopyableUserData(REFERENCED_CLASS_KEY);
                if (refClass != null) {
                    element.putCopyableUserData(REFERENCED_CLASS_KEY, null);
                    PsiManager manager = refClass.getManager();
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)refClass.getProject());
                    PsiElement refElement1 = ref.resolve();
                    try {
                        if (refClass != refElement1 && !manager.areElementsEquivalent((PsiElement)refClass, refElement1)) {
                            if (((CompositeElement)element).findChildByRole(54) == null) {
                                ref = (PsiJavaCodeReferenceElement)ref.bindToElement((PsiElement)refClass);
                            }
                        } else {
                            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences((PsiElement)ref, 4096);
                        }
                        element = (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)ref);
                    }
                    catch (IncorrectOperationException e) {
                        ((PsiImportHolder)ref.getContainingFile()).importClass(refClass);
                    }
                } else {
                    PsiMember refMember = (PsiMember)element.getCopyableUserData(REFERENCED_MEMBER_KEY);
                    if (refMember != null) {
                        LOG.assertTrue(ref instanceof PsiReferenceExpression);
                        element.putCopyableUserData(REFERENCED_MEMBER_KEY, null);
                        PsiElement refElement1 = ref.resolve();
                        if (refMember != refElement1 && !refMember.getManager().areElementsEquivalent((PsiElement)refMember, refElement1)) {
                            try {
                                ref = (PsiJavaCodeReferenceElement)((PsiReferenceExpression)ref).bindToElementViaStaticImport(refMember.getContainingClass());
                            }
                            catch (IncorrectOperationException e) {
                                // empty catch block
                            }
                            element = (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)ref);
                        }
                    }
                }
            } else if (element.getElementType() == JavaElementType.MODIFIER_LIST && element.getUserData(INTERFACE_MODIFIERS_FLAG_KEY) != null) {
                element.putUserData(INTERFACE_MODIFIERS_FLAG_KEY, null);
                try {
                    PsiModifierList modifierList = (PsiModifierList)SourceTreeToPsiMap.treeElementToPsi(element);
                    if (element.getTreeParent().getElementType() == JavaElementType.FIELD) {
                        modifierList.setModifierProperty("public", true);
                        modifierList.setModifierProperty("static", true);
                        modifierList.setModifierProperty("final", true);
                    } else if (element.getTreeParent().getElementType() == JavaElementType.METHOD) {
                        modifierList.setModifierProperty("public", true);
                        modifierList.setModifierProperty("abstract", true);
                    } else if (element.getTreeParent().getElementType() == JavaElementType.ANNOTATION_METHOD) {
                        modifierList.setModifierProperty("public", true);
                        modifierList.setModifierProperty("abstract", true);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        } else if (shallDecodeEscapedTexts && element instanceof LeafElement && !(element instanceof OuterLanguageElement) && !JavaChangeUtilSupport.isInCData(element) && !Comparing.equal((String)(original = element.getText()), (String)(escaped = StringUtil.escapeXml((String)original))) && element.getCopyableUserData(ALREADY_ESCAPED) == null) {
            LeafElement copy = ((LeafElement)element).replaceWithText(escaped);
            copy.putCopyableUserData(ALREADY_ESCAPED, Boolean.TRUE);
            return copy;
        }
        return element;
    }

    private static boolean conversionMayApply(ASTNode element) {
        PsiElement psi = element.getPsi();
        if (psi == null || !psi.isValid()) {
            return false;
        }
        PsiFile file = psi.getContainingFile();
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        return baseLanguage == StdLanguages.JSPX && file.getLanguage() != baseLanguage;
    }

    @Override
    public void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> encodingState) {
        String unescapedText;
        String originalText;
        boolean shallEncodeEscapedTexts = JavaChangeUtilSupport.shallEncodeEscapedTexts(original, encodingState);
        if (original instanceof CompositeElement) {
            if (original.getElementType() == JavaElementType.JAVA_CODE_REFERENCE || original.getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                JavaChangeUtilSupport.encodeInformationInRef(element, original);
            } else if (original.getElementType() == JavaElementType.MODIFIER_LIST && (original.getTreeParent().getElementType() == JavaElementType.FIELD || original.getTreeParent().getElementType() == JavaElementType.METHOD || original.getTreeParent().getElementType() == JavaElementType.ANNOTATION_METHOD) && original.getTreeParent().getTreeParent().getElementType() == JavaElementType.CLASS && (((PsiClass)SourceTreeToPsiMap.treeElementToPsi(original.getTreeParent().getTreeParent())).isInterface() || ((PsiClass)SourceTreeToPsiMap.treeElementToPsi(original.getTreeParent().getTreeParent())).isAnnotationType())) {
                element.putUserData(INTERFACE_MODIFIERS_FLAG_KEY, Boolean.TRUE);
            }
        } else if (shallEncodeEscapedTexts && original instanceof LeafElement && !(original instanceof OuterLanguageElement) && !JavaChangeUtilSupport.isInCData(original) && !Comparing.equal((String)(originalText = element.getText()), (String)(unescapedText = StringUtil.unescapeXml((String)originalText)))) {
            LeafElement replaced = ((LeafElement)element).rawReplaceWithText(unescapedText);
            element.putCopyableUserData(ALREADY_ESCAPED, null);
            replaced.putCopyableUserData(ALREADY_ESCAPED, null);
        }
    }

    private static Boolean shallEncodeEscapedTexts(ASTNode original, Map<Object, Object> encodingState) {
        Boolean shallEncodeEscapedTexts = (Boolean)encodingState.get(ESCAPEMENT_ENGAGED);
        if (shallEncodeEscapedTexts == null) {
            shallEncodeEscapedTexts = JavaChangeUtilSupport.conversionMayApply(original);
            encodingState.put(ESCAPEMENT_ENGAGED, shallEncodeEscapedTexts);
        }
        return shallEncodeEscapedTexts;
    }

    private static boolean isInCData(ASTNode element) {
        ASTNode leaf = element;
        while (leaf != null) {
            if (leaf instanceof OuterLanguageElement) {
                return leaf.getText().indexOf("<![CDATA[") >= 0;
            }
            leaf = TreeUtil.prevLeaf(leaf);
        }
        return false;
    }

    private static void encodeInformationInRef(TreeElement ref, ASTNode original) {
        block10: {
            block11: {
                block9: {
                    if (original.getElementType() != JavaElementType.REFERENCE_EXPRESSION) break block9;
                    PsiJavaCodeReferenceElement javaRefElement = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(original);
                    assert (javaRefElement != null);
                    JavaResolveResult resolveResult = javaRefElement.advancedResolve(false);
                    PsiElement target = resolveResult.getElement();
                    if (target instanceof PsiClass && original.getTreeParent().getElementType() == JavaElementType.REFERENCE_EXPRESSION) {
                        ref.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)target);
                    } else if ((target instanceof PsiMethod || target instanceof PsiField) && ((PsiMember)target).hasModifierProperty("static") && resolveResult.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) {
                        ref.putCopyableUserData(REFERENCED_MEMBER_KEY, (PsiMember)target);
                    }
                    break block10;
                }
                if (original.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) break block11;
                switch (((PsiJavaCodeReferenceElementImpl)original).getKind()) {
                    case 1: 
                    case 3: 
                    case 6: {
                        PsiElement target = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(original)).resolve();
                        if (target instanceof PsiClass) {
                            ref.putCopyableUserData(REFERENCED_CLASS_KEY, (PsiClass)target);
                            break;
                        }
                        break block10;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    default: {
                        LOG.assertTrue(false);
                        break;
                    }
                }
                break block10;
            }
            LOG.error("Wrong element type: " + original.getElementType());
        }
    }

    private static void encodeInfoInTypeElement(ASTNode typeElement, PsiType type) {
        if (type instanceof PsiPrimitiveType) {
            return;
        }
        LOG.assertTrue(typeElement.getElementType() == JavaElementType.TYPE);
        if (type instanceof PsiArrayType) {
            ASTNode firstChild = typeElement.getFirstChildNode();
            LOG.assertTrue(firstChild.getElementType() == JavaElementType.TYPE);
            JavaChangeUtilSupport.encodeInfoInTypeElement(firstChild, ((PsiArrayType)type).getComponentType());
        } else if (type instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type).getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaChangeUtilSupport.encodeInfoInTypeElement(lastChild, bound);
        } else if (type instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type).getWildcard().getBound();
            if (bound == null) {
                return;
            }
            ASTNode lastChild = typeElement.getLastChildNode();
            if (lastChild.getElementType() != JavaElementType.TYPE) {
                return;
            }
            JavaChangeUtilSupport.encodeInfoInTypeElement(lastChild, bound);
        } else if (type instanceof PsiIntersectionType) {
            JavaChangeUtilSupport.encodeInfoInTypeElement(typeElement, ((PsiIntersectionType)type).getRepresentative());
        } else {
            LOG.assertTrue(type instanceof PsiClassType);
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass referencedClass = resolveResult.getElement();
            if (referencedClass == null) {
                return;
            }
            if (referencedClass instanceof PsiAnonymousClass) {
                JavaChangeUtilSupport.encodeInfoInTypeElement(typeElement, (PsiType)((PsiAnonymousClass)referencedClass).getBaseClassType());
            } else {
                ASTNode reference = typeElement.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
                if (reference instanceof CompositeElement) {
                    JavaChangeUtilSupport.encodeClassTypeInfoInReference((CompositeElement)reference, resolveResult.getElement(), resolveResult.getSubstitutor());
                }
            }
        }
    }

    private static void encodeClassTypeInfoInReference(@NotNull CompositeElement reference, PsiClass referencedClass, PsiSubstitutor substitutor) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/JavaChangeUtilSupport.encodeClassTypeInfoInReference must not be null");
        }
        reference.putCopyableUserData(REFERENCED_CLASS_KEY, referencedClass);
        PsiTypeParameter[] typeParameters = referencedClass.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        ASTNode referenceParameterList = reference.findChildByRole(246);
        int index = 0;
        for (ASTNode child = referenceParameterList.getFirstChildNode(); child != null && index < typeParameters.length; child = child.getTreeNext()) {
            if (child.getElementType() != JavaElementType.TYPE) continue;
            PsiType substitutedType = substitutor.substitute(typeParameters[index]);
            if (substitutedType != null) {
                JavaChangeUtilSupport.encodeInfoInTypeElement(child, substitutedType);
            }
            ++index;
        }
        ASTNode qualifier = reference.findChildByRole(54);
        if (qualifier != null) {
            if (referencedClass.hasModifierProperty("static")) {
                return;
            }
            PsiClass outerClass = referencedClass.getContainingClass();
            if (outerClass != null) {
                JavaChangeUtilSupport.encodeClassTypeInfoInReference((CompositeElement)qualifier, outerClass, substitutor);
            }
        }
    }

    static {
        JavaChangeUtilSupport instance = new JavaChangeUtilSupport();
        ChangeUtil.registerCopyHandler(instance);
        ChangeUtil.registerTreeGenerator(instance);
        ALREADY_ESCAPED = new Key("ALREADY_ESCAPED");
        ESCAPEMENT_ENGAGED = new Key("ESCAPEMENT_ENGAGED");
        REFERENCED_CLASS_KEY = Key.create((String)"REFERENCED_CLASS_KEY");
        REFERENCED_MEMBER_KEY = Key.create((String)"REFERENCED_MEMBER_KEY");
        INTERFACE_MODIFIERS_FLAG_KEY = Key.create((String)"INTERFACE_MODIFIERS_FLAG_KEY");
    }
}

