/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet");
    private static final FileType[] EMPTY_FILE_TYPES = new FileType[0];
    private static final char SEPARATOR = '/';
    private static final String SEPARATOR_STRING = "/";
    private static final Key<CachedValue<Collection<PsiFileSystemItem>>> DEFAULT_CONTEXTS_KEY = new Key("default file contexts");
    public static final CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> DEFAULT_PATH_EVALUATOR_OPTION = new CustomizableReferenceProvider.CustomizationKey(PsiBundle.message((String)"default.path.evaluator.option", (Object[])new Object[0]));
    public static final Function<PsiFile, Collection<PsiFileSystemItem>> ABSOLUTE_TOP_LEVEL = new Function<PsiFile, Collection<PsiFileSystemItem>>(){

        @Nullable
        public Collection<PsiFileSystemItem> fun(PsiFile file) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file);
        }
    };
    private FileReference[] myReferences;
    private PsiElement myElement;
    private final int myStartInElement;
    private final boolean myCaseSensitive;
    private final String myPathString;
    private Collection<PsiFileSystemItem> myDefaultContexts;
    private final boolean myEndingSlashNotAllowed;
    private boolean myEmptyPathAllowed;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private FileType[] mySuitableFileTypes;

    public FileReferenceSet(String str, PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType[] suitableFileTypes) {
        this.myElement = element;
        this.myStartInElement = startInElement;
        this.myCaseSensitive = caseSensitive;
        this.myPathString = str.trim();
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        this.myEmptyPathAllowed = !endingSlashNotAllowed;
        this.myOptions = provider instanceof CustomizableReferenceProvider ? ((CustomizableReferenceProvider)provider).getOptions() : null;
        this.mySuitableFileTypes = suitableFileTypes;
        this.reparse(str);
    }

    public static FileReferenceSet createSet(PsiElement element, final boolean soft, boolean endingSlashNotAllowed, final boolean urlEncoded) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            text = helper.trimUrl(text);
        }
        return new FileReferenceSet(text, element, offset, null, true, endingSlashNotAllowed){

            @Override
            protected boolean isUrlEncoded() {
                return urlEncoded;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
    }

    public FileReferenceSet(String str, PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        this(str, element, startInElement, provider, isCaseSensitive, true);
    }

    public FileReferenceSet(@NotNull String str, PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.<init> must not be null");
        }
        this(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null);
    }

    public FileReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.<init> must not be null");
        }
        this.myElement = element;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        this.myStartInElement = range.getStartOffset();
        String s = range.substring(element.getText());
        this.myPathString = s.trim();
        this.myEndingSlashNotAllowed = true;
        this.myCaseSensitive = false;
        this.reparse(s);
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    void setElement(PsiElement element) {
        this.myElement = element;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new FileReference(this, range, index, text);
    }

    private void reparse(String str) {
        int nextSlash;
        ArrayList<FileReference> referencesList = new ArrayList<FileReference>();
        int currentSlash = -1;
        while (currentSlash + 1 < str.length() && Character.isWhitespace(str.charAt(currentSlash + 1))) {
            ++currentSlash;
        }
        if (currentSlash + 1 < str.length() && str.charAt(currentSlash + 1) == '/') {
            ++currentSlash;
        }
        int index = 0;
        if (str.equals(SEPARATOR_STRING)) {
            FileReference fileReference = this.createFileReference(new TextRange(this.myStartInElement, this.myStartInElement + 1), index++, SEPARATOR_STRING);
            referencesList.add(fileReference);
        }
        do {
            String subreferenceText = (nextSlash = str.indexOf(47, currentSlash + 1)) > 0 ? str.substring(currentSlash + 1, nextSlash) : str.substring(currentSlash + 1);
            FileReference ref = this.createFileReference(new TextRange(this.myStartInElement + currentSlash + 1, this.myStartInElement + (nextSlash > 0 ? nextSlash : str.length())), index++, subreferenceText);
            referencesList.add(ref);
        } while ((currentSlash = nextSlash) >= 0);
        this.setReferences(referencesList.toArray(new FileReference[referencesList.size()]));
    }

    private void setReferences(FileReference[] references) {
        this.myReferences = references;
    }

    public FileReference getReference(int index) {
        return this.myReferences[index];
    }

    @NotNull
    public FileReference[] getAllReferences() {
        if (this.myReferences == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getAllReferences must not return null");
        }
        return this.myReferences;
    }

    protected boolean isSoft() {
        return false;
    }

    protected boolean isUrlEncoded() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        if (this.myDefaultContexts == null) {
            this.myDefaultContexts = this.computeDefaultContexts();
        }
        Collection<PsiFileSystemItem> collection = this.myDefaultContexts;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getDefaultContexts must not return null");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        Collection roots;
        Function<PsiFile, Collection<PsiFileSystemItem>> value;
        Collection<Object> collection;
        final PsiFile file = this.getContainingFile();
        if (file == null) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.computeDefaultContexts must not return null");
            return collection;
        }
        if (this.myOptions == null || (value = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) == null || (roots = (Collection)value.fun((Object)file)) == null) {
            if (this.isAbsolutePathReference()) {
                collection = FileReferenceSet.getAbsoluteTopLevelDirLocations(file);
                if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.computeDefaultContexts must not return null");
                return collection;
            } else {
                CachedValueProvider<Collection<PsiFileSystemItem>> myDefaultContextProvider = new CachedValueProvider<Collection<PsiFileSystemItem>>(){

                    public CachedValueProvider.Result<Collection<PsiFileSystemItem>> compute() {
                        Collection contexts = FileReferenceSet.this.getContextByFile(file);
                        return CachedValueProvider.Result.createSingleDependency((Object)contexts, (Object)PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                    }
                };
                CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.myElement.getProject());
                Collection value2 = (Collection)cachedValuesManager.getCachedValue((UserDataHolder)file, DEFAULT_CONTEXTS_KEY, (CachedValueProvider)myDefaultContextProvider, false);
                collection = value2 == null ? Collections.emptyList() : value2;
                if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.computeDefaultContexts must not return null");
                return collection;
            }
        }
        for (PsiFileSystemItem root : roots) {
            LOG.assertTrue(root != null, (Object)("Default path evaluator " + value + " produced a null root for " + file));
        }
        collection = roots;
        if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.computeDefaultContexts must not return null");
        return collection;
    }

    @Nullable
    private PsiFile getContainingFile() {
        PsiFile file = InjectedLanguageUtil.getTopLevelFile((PsiElement)this.myElement.getContainingFile());
        if (file == null) {
            LOG.error("Invalid element: " + this.myElement);
        }
        return file.getOriginalFile();
    }

    @Nullable
    private Collection<PsiFileSystemItem> getContextByFile(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        FileContextProvider contextProvider;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getContextByFile must not be null");
        }
        PsiElement context = file.getContext();
        if (context != null) {
            file = context.getContainingFile();
        }
        if (this.useIncludingFileAsContext() && (contextProvider = FileContextProvider.getProvider((PsiFile)file)) != null) {
            Collection folders = contextProvider.getContextFolders(file);
            if (!folders.isEmpty()) {
                return folders;
            }
            PsiFile contextFile = contextProvider.getContextFile(file);
            if (contextFile != null) {
                return Collections.singleton(contextFile.getParent());
            }
        }
        if ((virtualFile = file.getOriginalFile().getVirtualFile()) != null) {
            PsiDirectory directory;
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
            Project project = file.getProject();
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project, virtualFile)) continue;
                list.addAll(helper.getContexts(project, virtualFile));
            }
            if (list.size() > 0) {
                return list;
            }
            VirtualFile parent = virtualFile.getParent();
            if (parent != null && (directory = file.getManager().findDirectory(parent)) != null) {
                return Collections.singleton(directory);
            }
        }
        return Collections.emptyList();
    }

    public String getPathString() {
        return this.myPathString;
    }

    public boolean isAbsolutePathReference() {
        return this.myPathString.startsWith(SEPARATOR_STRING);
    }

    protected boolean useIncludingFileAsContext() {
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolve() {
        FileReference lastReference = this.getLastReference();
        return lastReference == null ? null : lastReference.resolve();
    }

    @Nullable
    public FileReference getLastReference() {
        return this.myReferences == null || this.myReferences.length == 0 ? null : this.myReferences[this.myReferences.length - 1];
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Collection<PsiFileSystemItem> getAbsoluteTopLevelDirLocations(@NotNull PsiFile file) {
        List<Object> list;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getAbsoluteTopLevelDirLocations must not be null");
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getAbsoluteTopLevelDirLocations must not return null");
            return list;
        }
        Project project = file.getProject();
        PsiDirectory parent = file.getParent();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)(parent == null ? file : parent));
        if (module == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getAbsoluteTopLevelDirLocations must not return null");
            return list;
        }
        FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
        ArrayList<PsiFileSystemItem> list2 = new ArrayList<PsiFileSystemItem>();
        FileReferenceHelper[] arr$ = helpers;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block12: {
                Iterator<PsiFileSystemItem> i$2;
                Collection<PsiFileSystemItem> roots;
                FileReferenceHelper helper;
                block13: {
                    block11: {
                        if (i$ >= len$) break block11;
                        helper = arr$[i$];
                        if (!helper.isMine(project, virtualFile)) break block12;
                        roots = helper.getRoots(module);
                        i$2 = roots.iterator();
                        break block13;
                    }
                    if (list2.size() == 0) {
                        list2.addAll(FileReferenceHelperRegistrar.getNotNullHelper(file).getRoots(module));
                    }
                    if ((list = list2) != null) return list;
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getAbsoluteTopLevelDirLocations must not return null");
                }
                while (i$2.hasNext()) {
                    PsiFileSystemItem root = i$2.next();
                    LOG.assertTrue(root != null, (Object)("Helper " + helper + " produced a null root for " + file));
                }
                list2.addAll(roots);
            }
            ++i$;
        }
    }

    protected Condition<PsiElement> createCondition() {
        return Condition.TRUE;
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key, Option value) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key, value);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return true;
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return true;
    }

    @NotNull
    public FileType[] getSuitableFileTypes() {
        FileType[] fileTypeArray = this.mySuitableFileTypes == null ? EMPTY_FILE_TYPES : this.mySuitableFileTypes;
        if (fileTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet.getSuitableFileTypes must not return null");
        }
        return fileTypeArray;
    }

    public boolean isEmptyPathAllowed() {
        return this.myEmptyPathAllowed;
    }

    public void setEmptyPathAllowed(boolean emptyPathAllowed) {
        this.myEmptyPathAllowed = emptyPathAllowed;
    }
}

