/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageTokenSeparatorGenerators;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.openapi.command.AbnormalCommandTerminationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.Helper;
import com.intellij.psi.impl.source.codeStyle.HelperFactory;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeEditUtil {
    private static final Key<Boolean> GENERATED_FLAG = new Key("CREATED BY IDEA");
    private static final Key<Integer> INDENT_INFO = new Key("INDENTATION");
    private static final Key<Boolean> REFORMAT_KEY = new Key("REFORMAT BEFORE THIS ELEMENT");
    public static final Key<Boolean> OUTER_OK = new Key("OUTER_OK");

    private CodeEditUtil() {
    }

    public static void addChild(ASTNode parent, ASTNode child, ASTNode anchorBefore) {
        CodeEditUtil.addChildren(parent, child, child, anchorBefore);
    }

    public static void removeChild(ASTNode parent, @NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.removeChild must not be null");
        }
        CodeEditUtil.removeChildren(parent, child, child);
    }

    public static ASTNode addChildren(ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last, ASTNode anchorBefore) {
        ASTNode anchorPrev;
        if (first == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.addChildren must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.addChildren must not be null");
        }
        ASTNode lastChild = last.getTreeNext();
        for (ASTNode current = first; current != lastChild; current = current.getTreeNext()) {
            CodeEditUtil.saveWhitespacesInfo(current);
            CodeEditUtil.checkForOuters(current);
        }
        if (anchorBefore != null && CodeEditUtil.isComment(anchorBefore.getElementType()) && (anchorPrev = anchorBefore.getTreePrev()) != null && anchorPrev.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorPrev;
        }
        parent.addChildren(first, lastChild, anchorBefore);
        ASTNode firstAddedLeaf = CodeEditUtil.findFirstLeaf(first, last);
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        if (firstAddedLeaf != null) {
            ASTNode lastAddedLeaf;
            ASTNode placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, firstAddedLeaf, CodeEditUtil.isFormattingRequiered(prevLeaf, first), false);
            if (placeHolderEnd != prevLeaf && first == firstAddedLeaf) {
                first = placeHolderEnd;
            }
            if ((placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(lastAddedLeaf = CodeEditUtil.findLastLeaf(first, last), TreeUtil.nextLeaf(last), true, false)) != lastAddedLeaf && lastAddedLeaf == first) {
                first = placeHolderEnd;
            }
        } else {
            CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, TreeUtil.nextLeaf(last), CodeEditUtil.isFormattingRequiered(prevLeaf, first), false);
        }
        return first;
    }

    private static boolean isComment(IElementType type) {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage());
        return def != null && def.getCommentTokens().contains(type);
    }

    private static boolean isFormattingRequiered(ASTNode prevLeaf, ASTNode first) {
        while (first != null) {
            for (ASTNode current = prevLeaf; current != null; current = current.getTreeParent()) {
                if (current.getTreeNext() != first) continue;
                return true;
            }
            ASTNode parent = first.getTreeParent();
            if (parent == null || !parent.getTextRange().equals((Object)first.getTextRange())) break;
            first = parent;
        }
        return false;
    }

    public static void checkForOuters(ASTNode element) {
        if (element instanceof OuterLanguageElement && element.getCopyableUserData(OUTER_OK) == null) {
            throw new AbnormalCommandTerminationException();
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            CodeEditUtil.checkForOuters(child);
        }
    }

    public static void saveWhitespacesInfo(ASTNode first) {
        if (first == null || CodeEditUtil.isNodeGenerated(first) || CodeEditUtil.getOldIndentation(first) >= 0) {
            return;
        }
        PsiFile containingFile = first.getPsi().getContainingFile();
        Helper helper = HelperFactory.createHelper(containingFile.getFileType(), containingFile.getProject());
        CodeEditUtil.setOldIndentation((TreeElement)first, helper.getIndent(first));
    }

    public static int getOldIndentation(ASTNode node) {
        if (node == null) {
            return -1;
        }
        Integer stored = (Integer)node.getCopyableUserData(INDENT_INFO);
        return stored != null ? stored : -1;
    }

    public static void removeChildren(ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.removeChildren must not be null");
        }
        if (last == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.removeChildren must not be null");
        }
        boolean tailingElement = last.getStartOffset() + last.getTextLength() == parent.getStartOffset() + parent.getTextLength();
        boolean forceReformat = CodeEditUtil.needToForceReformat(parent, first, last);
        CodeEditUtil.saveWhitespacesInfo(first);
        for (TreeElement child = (TreeElement)first; child != null && child != last; child = child.getTreeNext()) {
        }
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        ASTNode nextLeaf = TreeUtil.nextLeaf(first);
        parent.removeRange(first, last.getTreeNext());
        ASTNode nextLeafToAdjust = nextLeaf;
        if (nextLeafToAdjust != null && nextLeafToAdjust.getTreeParent() == null) {
            nextLeafToAdjust = prevLeaf.getTreeNext();
        }
        CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, nextLeafToAdjust, forceReformat, tailingElement);
    }

    private static boolean needToForceReformat(ASTNode parent, ASTNode first, ASTNode last) {
        return parent == null || first.getStartOffset() != parent.getStartOffset() || parent.getText().trim().length() == CodeEditUtil.getTrimmedTextLength(first, last) && CodeEditUtil.needToForceReformat(parent.getTreeParent(), parent, parent);
    }

    private static int getTrimmedTextLength(ASTNode first, ASTNode last) {
        StringBuilder buffer = new StringBuilder();
        while (first != last.getTreeNext()) {
            buffer.append(first.getText());
            first = first.getTreeNext();
        }
        return buffer.toString().trim().length();
    }

    public static void replaceChild(ASTNode parent, @NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.replaceChild must not be null");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.replaceChild must not be null");
        }
        CodeEditUtil.saveWhitespacesInfo(oldChild);
        CodeEditUtil.saveWhitespacesInfo(newChild);
        CodeEditUtil.checkForOuters(oldChild);
        CodeEditUtil.checkForOuters(newChild);
        LeafElement oldFirst = TreeUtil.findFirstLeaf(oldChild);
        parent.replaceChild(oldChild, newChild);
        LeafElement firstLeaf = TreeUtil.findFirstLeaf(newChild);
        ASTNode prevToken = TreeUtil.prevLeaf(newChild);
        if (firstLeaf != null) {
            ASTNode nextLeaf = TreeUtil.nextLeaf(newChild);
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, firstLeaf, CodeEditUtil.isFormattingRequiered(prevToken, newChild), false);
            if (nextLeaf != null && !CharArrayUtil.containLineBreaks((CharSequence)nextLeaf.getText())) {
                CodeEditUtil.makePlaceHolderBetweenTokens(TreeUtil.prevLeaf(nextLeaf), nextLeaf, false, false);
            }
        } else {
            ASTNode whitespaceNode;
            if (oldFirst != null && prevToken == null && (whitespaceNode = newChild.getTreeNext()) != null && whitespaceNode.getElementType() == TokenType.WHITE_SPACE) {
                parent.removeChild(whitespaceNode);
            }
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, TreeUtil.nextLeaf(newChild), CodeEditUtil.isFormattingRequiered(prevToken, newChild), false);
        }
    }

    @Nullable
    private static ASTNode findFirstLeaf(ASTNode first, ASTNode last) {
        do {
            LeafElement leaf;
            if ((leaf = TreeUtil.findFirstLeaf(first)) != null) {
                return leaf;
            }
            if ((first = first.getTreeNext()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode findLastLeaf(ASTNode first, ASTNode last) {
        do {
            LeafElement leaf;
            if ((leaf = TreeUtil.findLastLeaf(last)) != null) {
                return leaf;
            }
            if ((last = last.getTreePrev()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    private static ASTNode makePlaceHolderBetweenTokens(ASTNode left, ASTNode right, boolean forceReformat, boolean normalizeTailingWhitespace) {
        if (right == null) {
            return left;
        }
        CodeEditUtil.markToReformatBefore(right, false);
        if (left == null) {
            CodeEditUtil.markToReformatBefore(right, true);
        } else if (left.getElementType() == TokenType.WHITE_SPACE && left.getTreeNext() == null && normalizeTailingWhitespace) {
            ASTNode prevLeaf = TreeUtil.prevLeaf(left);
            left.getTreeParent().removeChild(left);
            CodeEditUtil.markToReformatBeforeOrInsertWhitespace(prevLeaf, right);
            left = right;
        } else if (left.getElementType() == TokenType.WHITE_SPACE && right.getElementType() == TokenType.WHITE_SPACE) {
            int rightBlankLines;
            boolean leaveRightText;
            int leftBlankLines = CodeEditUtil.getBlankLines(left.getText());
            boolean bl = leaveRightText = leftBlankLines < (rightBlankLines = CodeEditUtil.getBlankLines(right.getText()));
            String text = leftBlankLines == 0 && rightBlankLines == 0 ? left.getText() + right.getText() : (leaveRightText ? right.getText() : left.getText());
            if (leaveRightText || forceReformat) {
                LeafElement merged = ASTFactory.whitespace(text);
                if (!leaveRightText) {
                    left.getTreeParent().replaceChild(left, (ASTNode)merged);
                    right.getTreeParent().removeChild(right);
                } else {
                    right.getTreeParent().replaceChild(right, (ASTNode)merged);
                    left.getTreeParent().removeChild(left);
                }
                left = merged;
            } else {
                right.getTreeParent().removeChild(right);
            }
        } else if (left.getElementType() != TokenType.WHITE_SPACE || forceReformat) {
            if (right.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(right);
            } else if (left.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(left);
            } else {
                CodeEditUtil.markToReformatBeforeOrInsertWhitespace(left, right);
            }
        }
        return left;
    }

    private static void markWhitespaceForReformat(ASTNode right) {
        String text = right.getText();
        LeafElement merged = ASTFactory.whitespace(text);
        right.getTreeParent().replaceChild(right, (ASTNode)merged);
    }

    private static void markToReformatBeforeOrInsertWhitespace(ASTNode left, @NotNull ASTNode right) {
        if (right == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.markToReformatBeforeOrInsertWhitespace must not be null");
        }
        Language leftLang = left != null ? PsiUtilBase.getNotAnyLanguage((ASTNode)left) : null;
        Language rightLang = PsiUtilBase.getNotAnyLanguage((ASTNode)right);
        ASTNode generatedWhitespace = null;
        if (leftLang != null && leftLang.isKindOf(rightLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(leftLang)).generateWhitespaceBetweenTokens(left, right);
        } else if (rightLang.isKindOf(leftLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(rightLang)).generateWhitespaceBetweenTokens(left, right);
        }
        if (generatedWhitespace != null) {
            TreeUtil.CommonParentState parentState = new TreeUtil.CommonParentState();
            TreeUtil.prevLeaf((TreeElement)right, parentState);
            parentState.nextLeafBranchStart.getTreeParent().addChild(generatedWhitespace, parentState.nextLeafBranchStart);
        } else {
            CodeEditUtil.markToReformatBefore(right, true);
        }
    }

    public static void markToReformatBefore(ASTNode right, boolean value) {
        if (value) {
            right.putCopyableUserData(REFORMAT_KEY, (Object)true);
        } else {
            right.putCopyableUserData(REFORMAT_KEY, null);
        }
    }

    private static int getBlankLines(String text) {
        int result = 0;
        int currentIndex = -1;
        while ((currentIndex = text.indexOf(10, currentIndex + 1)) >= 0) {
            ++result;
        }
        return result;
    }

    public static String getStringWhiteSpaceBetweenTokens(ASTNode first, ASTNode second, PsiFile file) {
        FormattingModelBuilder modelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (modelBuilder == null) {
            LeafElement leafElement = TreeUtil.nextLeaf((TreeElement)first, null);
            if (leafElement != second) {
                return leafElement.getText();
            }
            return null;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)file.getProject()).getCurrentSettings();
        return CodeEditUtil.getWhiteSpaceBeforeToken(second, file, true).generateNewWhiteSpace(settings.getIndentOptions(file.getFileType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndentInfo getWhiteSpaceBeforeToken(@NotNull ASTNode tokenNode, PsiFile file, boolean mayChangeLineFeeds) {
        if (tokenNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeEditUtil.getWhiteSpaceBeforeToken must not be null");
        }
        Project project = file.getProject();
        CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        int tokenStartOffset = tokenNode.getStartOffset();
        boolean oldValue = settings.XML_KEEP_LINE_BREAKS;
        int oldKeepBlankLines = settings.XML_KEEP_BLANK_LINES;
        settings.XML_KEEP_BLANK_LINES = 0;
        try {
            FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
            PsiElement element = file.findElementAt(tokenStartOffset);
            if (builder != null && LanguageFormatting.INSTANCE.forContext(element) != null) {
                TextRange textRange = element.getTextRange();
                FormattingModel model = builder.createModel((PsiElement)file, settings);
                IndentInfo indentInfo = FormatterEx.getInstanceEx().getWhiteSpaceBefore(model.getDocumentModel(), model.getRootBlock(), settings, settings.getIndentOptions(file.getFileType()), textRange, mayChangeLineFeeds);
                return indentInfo;
            }
            IndentInfo indentInfo = new IndentInfo(0, 0, 0);
            return indentInfo;
        }
        finally {
            settings.XML_KEEP_LINE_BREAKS = oldValue;
            settings.XML_KEEP_BLANK_LINES = oldKeepBlankLines;
        }
    }

    public static boolean isNodeGenerated(ASTNode node) {
        return node == null || node.getCopyableUserData(GENERATED_FLAG) != null;
    }

    public static void setNodeGenerated(ASTNode next, boolean value) {
        if (next == null) {
            return;
        }
        if (value) {
            next.putCopyableUserData(GENERATED_FLAG, (Object)true);
        } else {
            next.putCopyableUserData(GENERATED_FLAG, null);
        }
    }

    public static void setOldIndentation(TreeElement treeElement, int oldIndentation) {
        if (treeElement == null) {
            return;
        }
        if (oldIndentation >= 0) {
            treeElement.putCopyableUserData(INDENT_INFO, oldIndentation);
        } else {
            treeElement.putCopyableUserData(INDENT_INFO, null);
        }
    }

    public static boolean isMarkedToReformatBefore(TreeElement element) {
        return element.getCopyableUserData(REFORMAT_KEY) != null;
    }

    public static PsiElement createLineFeed(PsiManager manager) {
        return Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager).getPsi();
    }
}

