/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiTypeCodeFragmentImpl
extends PsiCodeFragmentImpl
implements PsiTypeCodeFragment {
    private final boolean myAllowEllipsis;

    public PsiTypeCodeFragmentImpl(Project manager, boolean isPhysical, boolean allowEllipsis, @NonNls String name, CharSequence text) {
        super(manager, JavaElementType.TYPE_TEXT, isPhysical, name, text);
        this.myAllowEllipsis = allowEllipsis;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiType getType() throws PsiTypeCodeFragment.TypeSyntaxException, PsiTypeCodeFragment.NoTypeException {
        class SyntaxError
        extends RuntimeException {
            SyntaxError() {
            }
        }
        PsiType psiType;
        PsiElement child;
        try {
            this.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitErrorElement(PsiErrorElement element) {
                    throw new SyntaxError();
                }
            });
        }
        catch (SyntaxError e) {
            throw new PsiTypeCodeFragment.TypeSyntaxException();
        }
        for (child = this.getFirstChild(); child != null && !(child instanceof PsiTypeElement); child = child.getNextSibling()) {
        }
        PsiTypeElement typeElement = (PsiTypeElement)child;
        if (typeElement == null) {
            throw new PsiTypeCodeFragment.NoTypeException();
        }
        PsiType type = typeElement.getType();
        PsiElement sibling = typeElement.getNextSibling();
        while (sibling instanceof PsiWhiteSpace) {
            sibling = sibling.getNextSibling();
        }
        if (sibling instanceof PsiJavaToken && "...".equals(sibling.getText())) {
            if (!this.myAllowEllipsis) {
                throw new PsiTypeCodeFragment.TypeSyntaxException();
            }
            psiType = new PsiEllipsisType(type);
            if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeCodeFragmentImpl.getType must not return null");
            return psiType;
        }
        psiType = type;
        if (psiType != null) return psiType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiTypeCodeFragmentImpl.getType must not return null");
    }

    public boolean isVoidValid() {
        return this.getOriginalFile().getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null;
    }
}

