/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightClassReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myText;
    private final String myClassName;
    private final PsiElement myContext;
    private final GlobalSearchScope myResolveScope;
    private final PsiClass myRefClass;
    private PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    private LightClassReference(PsiManager manager, @NonNls String text, @NonNls String className, PsiSubstitutor substitutor, GlobalSearchScope resolveScope) {
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myText = text;
        this.myClassName = className;
        this.myResolveScope = resolveScope;
        this.myContext = null;
        this.myRefClass = null;
        this.mySubstitutor = substitutor;
    }

    public LightClassReference(PsiManager manager, @NonNls String text, @NonNls String className, GlobalSearchScope resolveScope) {
        this(manager, text, className, null, resolveScope);
    }

    public LightClassReference(PsiManager manager, @NonNls String text, @NonNls String className, PsiSubstitutor substitutor, PsiElement context) {
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myText = text;
        this.myClassName = className;
        this.mySubstitutor = substitutor;
        this.myContext = context;
        this.myResolveScope = null;
        this.myRefClass = null;
    }

    public LightClassReference(PsiManager manager, @NonNls String text, PsiClass refClass) {
        this(manager, text, refClass, null);
    }

    public LightClassReference(PsiManager manager, @NonNls String text, PsiClass refClass, PsiSubstitutor substitutor) {
        super(manager, StdFileTypes.JAVA.getLanguage());
        this.myText = text;
        this.myRefClass = refClass;
        this.myResolveScope = null;
        this.myClassName = null;
        this.myContext = null;
        this.mySubstitutor = substitutor;
    }

    public PsiElement resolve() {
        if (this.myClassName != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            if (this.myContext != null) {
                return facade.getResolveHelper().resolveReferencedClass(this.myClassName, this.myContext);
            }
            return facade.findClass(this.myClassName, this.myResolveScope);
        }
        return this.myRefClass;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        PsiElement resolved = this.resolve();
        if (resolved == null) {
            javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.advancedResolve must not return null");
            return javaResolveResult;
        }
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = resolved instanceof PsiClass ? JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)((PsiClass)resolved)) : PsiSubstitutor.EMPTY;
        }
        if ((javaResolveResult = new CandidateInfo(resolved, substitutor)) != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.advancedResolve must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        if (JavaResolveResult.EMPTY_ARRAY != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.multiResolve must not return null");
    }

    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    public String getQualifiedName() {
        if (this.myClassName != null) {
            PsiClass psiClass = (PsiClass)this.resolve();
            if (psiClass != null) {
                return psiClass.getQualifiedName();
            }
            return this.myClassName;
        }
        return this.myRefClass.getQualifiedName();
    }

    public String getReferenceName() {
        if (this.myClassName != null) {
            return PsiNameHelper.getShortClassName((String)this.myClassName);
        }
        if (this.myRefClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)this.myRefClass).getBaseClassReference().getReferenceName();
        }
        return this.myRefClass.getName();
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            return null;
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            return name;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        return buf.toString();
    }

    public PsiElement copy() {
        if (this.myClassName != null) {
            if (this.myContext != null) {
                return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myContext);
            }
            return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myResolveScope);
        }
        return new LightClassReference(this.myManager, this.myText, this.myRefClass, this.mySubstitutor);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.bindToElement must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "LightClassReference:" + this.myText;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myRefClass == null || this.myRefClass.isValid();
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.getTypeParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }
}

