/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoIndex
extends FileBasedIndexExtension<TodoIndexEntry, Integer> {
    @NonNls
    public static final ID<TodoIndexEntry, Integer> NAME = ID.create((String)"TodoIndex");
    private final KeyDescriptor<TodoIndexEntry> myKeyDescriptor = new KeyDescriptor<TodoIndexEntry>(){

        public int getHashCode(TodoIndexEntry value) {
            return value.hashCode();
        }

        public boolean isEqual(TodoIndexEntry val1, TodoIndexEntry val2) {
            return val1.equals(val2);
        }

        public void save(DataOutput out, TodoIndexEntry value) throws IOException {
            out.writeUTF(value.pattern);
            out.writeBoolean(value.caseSensitive);
        }

        public TodoIndexEntry read(DataInput in) throws IOException {
            String pattern = in.readUTF();
            boolean caseSensitive = in.readBoolean();
            return new TodoIndexEntry(pattern, caseSensitive);
        }
    };
    private final DataExternalizer<Integer> myValueExternalizer = new DataExternalizer<Integer>(){

        public void save(DataOutput out, Integer value) throws IOException {
            out.writeInt(value);
        }

        public Integer read(DataInput in) throws IOException {
            return in.readInt();
        }
    };
    private final DataIndexer<TodoIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<TodoIndexEntry, Integer, FileContent>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Map<TodoIndexEntry, Integer> map(FileContent inputData) {
            Map<Object, Object> map;
            VirtualFile file = inputData.getFile();
            DataIndexer<TodoIndexEntry, Integer, FileContent> indexer = IdTableBuilding.getTodoIndexer(inputData.getFileType(), file);
            if (indexer != null) {
                map = indexer.map(inputData);
                if (map == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/todo/TodoIndex$4.map must not return null");
                return map;
            }
            map = Collections.emptyMap();
            if (map != null) return map;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/cache/impl/todo/TodoIndex$4.map must not return null");
        }
    };
    private final FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){
        private final FileTypeManager myFtManager = FileTypeManager.getInstance();

        @Override
        public boolean acceptInput(VirtualFile file) {
            if (!(file.getFileSystem() instanceof LocalFileSystem)) {
                return false;
            }
            FileType fileType = this.myFtManager.getFileTypeByFile(file);
            if (ProjectUtil.isProjectOrWorkspaceFile(file, fileType)) {
                return false;
            }
            if (fileType instanceof LanguageFileType) {
                Language lang = ((LanguageFileType)fileType).getLanguage();
                ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
                TokenSet commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
                return commentTokens != null;
            }
            return IdTableBuilding.isTodoIndexerRegistered(fileType) || fileType instanceof AbstractFileType;
        }
    };

    public TodoIndex(TodoConfiguration config) {
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("indexPatterns".equals(evt.getPropertyName())) {
                    FileBasedIndex.getInstance();
                    FileBasedIndex.requestRebuild(NAME);
                }
            }
        });
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public ID<TodoIndexEntry, Integer> getName() {
        return NAME;
    }

    @Override
    public DataIndexer<TodoIndexEntry, Integer, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @Override
    public KeyDescriptor<TodoIndexEntry> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @Override
    public DataExternalizer<Integer> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }
}

