/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class FileNode
extends PackageDependenciesNode {
    private final PsiFile myFile;
    private final boolean myMarked;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.packageDependencies.ui.FileNode");

    public FileNode(PsiFile file, boolean marked) {
        this.myFile = file;
        this.myMarked = marked;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        set.add(this.myFile);
    }

    @Override
    public boolean hasUnmarked() {
        return !this.myMarked;
    }

    @Override
    public boolean hasMarked() {
        return this.myMarked;
    }

    @Override
    public String toString() {
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        return virtualFile.getName();
    }

    @Override
    public Icon getOpenIcon() {
        return this.getIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.getIcon();
    }

    private Icon getIcon() {
        VirtualFile vFile = this.myFile.getVirtualFile();
        LOG.assertTrue(vFile != null);
        return IconUtil.getIcon((VirtualFile)vFile, (int)3, (Project)this.myFile.getProject());
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public int getContainingFiles() {
        return 1;
    }

    @Override
    public PsiElement getPsiElement() {
        return this.myFile;
    }

    @Override
    public FileStatus getStatus() {
        return FileStatusManager.getInstance((Project)this.myFile.getProject()).getStatus(this.myFile.getVirtualFile());
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileNode)) {
            return false;
        }
        FileNode fileNode = (FileNode)o;
        return this.myFile.equals(fileNode.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.myFile != null && this.myFile.isValid();
    }

    @Override
    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        return deps.containsKey(this.myFile);
    }
}

