/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesFileNameDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.JTree;

public class ChangesBrowserNodeRenderer
extends ColoredTreeCellRenderer {
    private final boolean myShowFlatten;
    private final Project myProject;
    private final IssueLinkRenderer myIssueLinkRenderer;
    private final boolean myHighlightProblems;

    public ChangesBrowserNodeRenderer(Project project, boolean showFlatten, boolean highlightProblems) {
        this.myShowFlatten = showFlatten;
        this.myProject = project;
        this.myHighlightProblems = highlightProblems;
        this.myIssueLinkRenderer = new IssueLinkRenderer(project, (SimpleColoredComponent)this);
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ChangesBrowserNode node = (ChangesBrowserNode)value;
        node.render(this, selected, expanded, hasFocus);
    }

    protected void appendFileName(VirtualFile vFile, String fileName, Color color) {
        ChangesFileNameDecorator decorator = ChangesFileNameDecorator.getInstance(this.myProject);
        if (decorator != null) {
            decorator.appendFileName(this, vFile, fileName, color, this.myHighlightProblems);
        } else {
            this.append(fileName, new SimpleTextAttributes(0, color));
        }
    }

    public void appendTextWithIssueLinks(String text, SimpleTextAttributes baseStyle) {
        this.myIssueLinkRenderer.appendTextWithLinks(text, baseStyle);
    }
}

