/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.vcs.changes.issueLinks.ClickableTreeCellRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeNodePartListener
extends LinkMouseListenerBase {
    private final ClickableTreeCellRenderer myRenderer;
    private DefaultMutableTreeNode myLastHitNode;
    private Component myRenderedComp;

    public TreeNodePartListener(ClickableTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    @Override
    protected Object getTagAt(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.myLastHitNode != treeNode) {
                this.myLastHitNode = treeNode;
                this.myRenderedComp = this.myRenderer.getTreeCellRendererComponent(tree, treeNode, false, false, treeNode.isLeaf(), -1, false);
            }
            if (this.myRenderedComp != null) {
                int compX = this.myRenderedComp.getX();
                int compY = this.myRenderedComp.getY();
                if (compX < e.getX() && compX + this.myRenderedComp.getWidth() > e.getX() && compY < e.getY() && compY + this.myRenderedComp.getHeight() > e.getY()) {
                    return this.myRenderer.getTag();
                }
            }
        }
        return null;
    }
}

