/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffActionExecutor {
    protected final DiffProvider myDiffProvider;
    protected final VirtualFile mySelectedFile;
    protected final Project myProject;
    private final BackgroundableActionEnabledHandler myHandler;

    protected DiffActionExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project, VcsBackgroundableActions actionKey) {
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project);
        this.myHandler = vcsManager.getBackgroundableActionHandler(actionKey);
        this.myDiffProvider = diffProvider;
        this.mySelectedFile = selectedFile;
        this.myProject = project;
    }

    @Nullable
    protected DiffContent createRemote(VcsRevisionNumber revisionNumber) throws IOException, VcsException {
        ContentRevision fileRevision = this.myDiffProvider.createFileContent(revisionNumber, this.mySelectedFile);
        if (fileRevision instanceof BinaryContentRevision) {
            final byte[] a = this.mySelectedFile.contentsToByteArray();
            final byte[] content = ((BinaryContentRevision)fileRevision).getBinaryContent();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Arrays.equals(a, content)) {
                        Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.are.identical", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                    } else {
                        Messages.showInfoMessage((String)VcsBundle.message((String)"message.text.binary.versions.are.different", (Object[])new Object[0]), (String)VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                    }
                }
            }, ModalityState.NON_MODAL);
            return null;
        }
        if (fileRevision != null) {
            String content = fileRevision.getContent();
            if (content == null) {
                throw new VcsException("Failed to load content");
            }
            return new SimpleContent(content, this.mySelectedFile.getFileType());
        }
        return null;
    }

    public void showDiff() {
        final Ref exceptionRef = new Ref();
        final Ref requestRef = new Ref();
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, VcsBundle.message((String)"show.diff.progress.title.detailed", (Object[])new Object[]{this.mySelectedFile.getPath()}), true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/actions/DiffActionExecutor$2.run must not be null");
                }
                VcsRevisionNumber revisionNumber = DiffActionExecutor.this.getRevisionNumber();
                try {
                    if (revisionNumber == null) {
                        return;
                    }
                    DiffContent remote = DiffActionExecutor.this.createRemote(revisionNumber);
                    if (remote == null) {
                        return;
                    }
                    SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, DiffActionExecutor.this.mySelectedFile.getPresentableUrl());
                    Document document = FileDocumentManager.getInstance().getDocument(DiffActionExecutor.this.mySelectedFile);
                    if (document == null) {
                        return;
                    }
                    DocumentContent content2 = new DocumentContent(this.myProject, document);
                    VcsRevisionNumber currentRevision = DiffActionExecutor.this.myDiffProvider.getCurrentRevision(DiffActionExecutor.this.mySelectedFile);
                    if (revisionNumber.compareTo((Object)currentRevision) > 0) {
                        request.setContents((DiffContent)content2, remote);
                        request.setContentTitles(VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]), revisionNumber.asString());
                    } else {
                        request.setContents(remote, (DiffContent)content2);
                        request.setContentTitles(revisionNumber.asString(), VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]));
                    }
                    request.addHint(DiffTool.HINT_SHOW_FRAME);
                    requestRef.set((Object)request);
                }
                catch (ProcessCanceledException e) {
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (IOException e) {
                    exceptionRef.set((Object)new VcsException((Throwable)e));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                DiffActionExecutor.this.myHandler.completed(VcsBackgroundableActions.keyFrom(DiffActionExecutor.this.mySelectedFile));
                if (!exceptionRef.isNull()) {
                    AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)((Object)exceptionRef.get()), VcsBundle.message((String)"message.title.diff", (Object[])new Object[0]));
                    return;
                }
                if (!requestRef.isNull()) {
                    DiffManager.getInstance().getDiffTool().show((DiffRequest)requestRef.get());
                }
            }
        };
        this.myHandler.register(VcsBackgroundableActions.keyFrom(this.mySelectedFile));
        ProgressManager.getInstance().run((Task)task);
    }

    public static void showDiff(DiffProvider diffProvider, VcsRevisionNumber revisionNumber, VirtualFile selectedFile, Project project, VcsBackgroundableActions actionKey) {
        CompareToFixedExecutor executor = new CompareToFixedExecutor(diffProvider, selectedFile, project, revisionNumber, actionKey);
        executor.showDiff();
    }

    @Nullable
    protected abstract VcsRevisionNumber getRevisionNumber();

    public static class DeletionAwareExecutor
    extends DiffActionExecutor {
        private boolean myFileStillExists;

        public DeletionAwareExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project, VcsBackgroundableActions actionKey) {
            super(diffProvider, selectedFile, project, actionKey);
        }

        @Override
        protected VcsRevisionNumber getRevisionNumber() {
            ItemLatestState itemState = this.myDiffProvider.getLastRevision(this.mySelectedFile);
            if (itemState == null) {
                return null;
            }
            this.myFileStillExists = itemState.isItemExists();
            return itemState.getNumber();
        }

        @Override
        protected DiffContent createRemote(VcsRevisionNumber revisionNumber) throws IOException, VcsException {
            if (this.myFileStillExists) {
                return super.createRemote(revisionNumber);
            }
            return new SimpleContent("", this.mySelectedFile.getFileType());
        }
    }

    public static class CompareToCurrentExecutor
    extends DiffActionExecutor {
        public CompareToCurrentExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project, VcsBackgroundableActions actionKey) {
            super(diffProvider, selectedFile, project, actionKey);
        }

        @Override
        @Nullable
        protected VcsRevisionNumber getRevisionNumber() {
            return this.myDiffProvider.getCurrentRevision(this.mySelectedFile);
        }
    }

    public static class CompareToFixedExecutor
    extends DiffActionExecutor {
        private final VcsRevisionNumber myNumber;

        public CompareToFixedExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project, VcsRevisionNumber number, VcsBackgroundableActions actionKey) {
            super(diffProvider, selectedFile, project, actionKey);
            this.myNumber = number;
        }

        @Override
        protected VcsRevisionNumber getRevisionNumber() {
            return this.myNumber;
        }
    }
}

