/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.packaging.ChooseLibrariesDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactEditorContextImpl
implements ArtifactEditorContext {
    private final ArtifactsStructureConfigurableContext myParent;
    private final ArtifactEditorEx myEditor;

    public ArtifactEditorContextImpl(ArtifactsStructureConfigurableContext parent, ArtifactEditorEx editor) {
        this.myParent = parent;
        this.myEditor = editor;
    }

    @NotNull
    public ModifiableArtifactModel getOrCreateModifiableArtifactModel() {
        ModifiableArtifactModel modifiableArtifactModel = this.myParent.getOrCreateModifiableArtifactModel();
        if (modifiableArtifactModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getOrCreateModifiableArtifactModel must not return null");
        }
        return modifiableArtifactModel;
    }

    public ModifiableModuleModel getModifiableModuleModel() {
        return this.myParent.getModifiableModuleModel();
    }

    @NotNull
    public ModifiableRootModel getOrCreateModifiableRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getOrCreateModifiableRootModel must not be null");
        }
        ModifiableRootModel modifiableRootModel = this.myParent.getOrCreateModifiableRootModel(module);
        if (modifiableRootModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getOrCreateModifiableRootModel must not return null");
        }
        return modifiableRootModel;
    }

    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType) {
        return this.myParent.getManifestFile(element, artifactType);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myParent.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getProject must not return null");
        }
        return project;
    }

    public CompositePackagingElement<?> getRootElement(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getRootElement must not be null");
        }
        return this.myParent.getRootElement(artifact);
    }

    public void editLayout(@NotNull Artifact artifact, Runnable runnable) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.editLayout must not be null");
        }
        this.myParent.editLayout(artifact, runnable);
    }

    public ArtifactEditor getOrCreateEditor(Artifact artifact) {
        return this.myParent.getOrCreateEditor(artifact);
    }

    public ArtifactEditor getThisArtifactEditor() {
        return this.myEditor;
    }

    public void selectArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.selectArtifact must not be null");
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(artifact, true);
    }

    public void selectFacet(@NotNull Facet<?> facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.selectFacet must not be null");
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(facet, true);
    }

    public void selectModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.selectModule must not be null");
        }
        ProjectStructureConfigurable.getInstance(this.getProject()).select(module.getName(), null, true);
    }

    public void selectLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.selectLibrary must not be null");
        }
        LibraryTable table = library.getTable();
        if (table != null) {
            ProjectStructureConfigurable.getInstance(this.getProject()).selectProjectOrGlobalLibrary(library, true);
        } else {
            Module module = ((LibraryImpl)library).getModule();
            if (module != null) {
                ModuleRootModel rootModel = this.myParent.getModulesProvider().getRootModel(module);
                String libraryName = library.getName();
                for (OrderEntry entry : rootModel.getOrderEntries()) {
                    if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                    ModuleLibraryOrderEntryImpl libraryEntry = (ModuleLibraryOrderEntryImpl)entry;
                    if ((libraryName == null || !libraryName.equals(libraryEntry.getLibraryName())) && (libraryName != null || !library.equals(libraryEntry.getLibrary()))) continue;
                    ModuleStructureConfigurable.getInstance(this.getProject()).selectOrderEntry(module, libraryEntry);
                    return;
                }
            }
        }
    }

    public List<Artifact> chooseArtifacts(List<? extends Artifact> artifacts, String title) {
        ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(this.getProject(), artifacts, title, null);
        dialog.show();
        return dialog.isOK() ? dialog.getChosenElements() : Collections.emptyList();
    }

    @NotNull
    public ArtifactModel getArtifactModel() {
        ArtifactModel artifactModel = this.myParent.getArtifactModel();
        if (artifactModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getArtifactModel must not return null");
        }
        return artifactModel;
    }

    @NotNull
    public ModulesProvider getModulesProvider() {
        ModulesProvider modulesProvider = this.myParent.getModulesProvider();
        if (modulesProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getModulesProvider must not return null");
        }
        return modulesProvider;
    }

    @NotNull
    public FacetsProvider getFacetsProvider() {
        FacetsProvider facetsProvider = this.myParent.getFacetsProvider();
        if (facetsProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getFacetsProvider must not return null");
        }
        return facetsProvider;
    }

    public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.findLibrary must not be null");
        }
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.findLibrary must not be null");
        }
        return this.myParent.findLibrary(level, libraryName);
    }

    public void queueValidation() {
        this.myParent.queueValidation(this.getArtifact());
    }

    @NotNull
    public ArtifactType getArtifactType() {
        ArtifactType artifactType = this.myEditor.getArtifact().getArtifactType();
        if (artifactType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorContextImpl.getArtifactType must not return null");
        }
        return artifactType;
    }

    public List<Module> chooseModules(List<Module> modules, String title) {
        ChooseModulesDialog dialog = new ChooseModulesDialog(this.getProject(), (List<? extends Module>)modules, title, null);
        dialog.show();
        List<Module> selected = dialog.getChosenElements();
        return dialog.isOK() ? selected : Collections.emptyList();
    }

    public List<Library> chooseLibraries(List<Library> libraries, String title) {
        ChooseLibrariesDialog dialog = new ChooseLibrariesDialog(this.getProject(), (List<? extends Library>)libraries, title, null);
        dialog.show();
        return dialog.isOK() ? dialog.getChosenElements() : Collections.emptyList();
    }

    public Artifact getArtifact() {
        return this.myEditor.getArtifact();
    }

    public ArtifactsStructureConfigurableContext getParent() {
        return this.myParent;
    }
}

