/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.JavaContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public abstract class JavaContentEntryEditor
extends ContentEntryEditor {
    private final CompilerModuleExtension myCompilerExtension = (CompilerModuleExtension)this.getModel().getModuleExtension(CompilerModuleExtension.class);

    public JavaContentEntryEditor(String contentEntryUrl) {
        super(contentEntryUrl, true, true);
    }

    @Override
    protected ContentRootPanel createContentRootPane() {
        return new JavaContentRootPanel(this){

            @Override
            @Nullable
            protected ContentEntry getContentEntry() {
                return JavaContentEntryEditor.this.getContentEntry();
            }
        };
    }

    @Override
    @Nullable
    protected ExcludeFolder doAddExcludeFolder(VirtualFile file) {
        boolean isCompilerOutput = this.isCompilerOutput(file);
        boolean isExplodedDirectory = this.isExplodedDirectory(file);
        if (isCompilerOutput || isExplodedDirectory) {
            if (isCompilerOutput) {
                this.myCompilerExtension.setExcludeOutput(true);
            }
            if (isExplodedDirectory) {
                this.getModel().setExcludeExplodedDirectory(true);
            }
            return null;
        }
        return super.doAddExcludeFolder(file);
    }

    @Override
    protected void doRemoveExcludeFolder(ExcludeFolder excludeFolder, VirtualFile file) {
        if (this.isCompilerOutput(file)) {
            this.myCompilerExtension.setExcludeOutput(false);
        }
        if (this.isExplodedDirectory(file)) {
            this.getModel().setExcludeExplodedDirectory(false);
        }
        super.doRemoveExcludeFolder(excludeFolder, file);
    }

    private boolean isCompilerOutput(@Nullable VirtualFile file) {
        VirtualFile compilerOutputPath = this.myCompilerExtension.getCompilerOutputPath();
        if (compilerOutputPath != null && compilerOutputPath.equals(file)) {
            return true;
        }
        VirtualFile compilerOutputPathForTests = this.myCompilerExtension.getCompilerOutputPathForTests();
        if (compilerOutputPathForTests != null && compilerOutputPathForTests.equals(file)) {
            return true;
        }
        if (this.myCompilerExtension.isCompilerOutputPathInherited()) {
            String compilerOutput = ProjectStructureConfigurable.getInstance(this.getModel().getModule().getProject()).getProjectConfig().getCompilerOutputUrl();
            if (file != null && Comparing.equal((String)compilerOutput, (String)file.getUrl())) {
                return true;
            }
        }
        return false;
    }

    private boolean isExplodedDirectory(VirtualFile file) {
        VirtualFile explodedDir = this.getModel().getExplodedDirectory();
        return explodedDir != null && explodedDir.equals(file);
    }
}

