/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReferenceManagerImpl
extends PathReferenceManager {
    private final StaticPathReferenceProvider myStaticProvider = new StaticPathReferenceProvider(null);
    private final PathReferenceProvider myGlobalPathsProvider = new GlobalPathReferenceProvider();
    private static final Comparator<PsiReference> START_OFFSET_COMPARATOR = new Comparator<PsiReference>(){

        @Override
        public int compare(PsiReference o1, PsiReference o2) {
            return o1.getRangeInElement().getStartOffset() - o2.getRangeInElement().getStartOffset();
        }
    };

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull Module module, @NotNull PsiElement element, PathReferenceProvider ... additionalProviders) {
        PathReference pathReference;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.getPathReference must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.getPathReference must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.getPathReference must not be null");
        }
        for (PathReferenceProvider provider : PathReferenceManagerImpl.getProviders()) {
            pathReference = provider.getPathReference(path, element);
            if (pathReference == null) continue;
            return pathReference;
        }
        for (PathReferenceProvider provider : additionalProviders) {
            pathReference = provider.getPathReference(path, element);
            if (pathReference == null) continue;
            return pathReference;
        }
        pathReference = this.myStaticProvider.getPathReference(path, element);
        if (pathReference != null) {
            return pathReference;
        }
        return null;
    }

    @Nullable
    public PathReference getCustomPathReference(@NotNull String path, @NotNull Module module, @NotNull PsiElement element, PathReferenceProvider ... providers) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.getCustomPathReference must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.getCustomPathReference must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.getCustomPathReference must not be null");
        }
        for (PathReferenceProvider provider : providers) {
            PathReference reference = provider.getPathReference(path, element);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    @NotNull
    public PathReferenceProvider getGlobalWebPathReferenceProvider() {
        PathReferenceProvider pathReferenceProvider = this.myGlobalPathsProvider;
        if (pathReferenceProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReferenceManagerImpl.getGlobalWebPathReferenceProvider must not return null");
        }
        return pathReferenceProvider;
    }

    @NotNull
    public PathReferenceProvider createStaticPathReferenceProvider(boolean relativePathsAllowed) {
        StaticPathReferenceProvider provider = new StaticPathReferenceProvider(null);
        provider.setRelativePathsAllowed(relativePathsAllowed);
        StaticPathReferenceProvider staticPathReferenceProvider = provider;
        if (staticPathReferenceProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReferenceManagerImpl.createStaticPathReferenceProvider must not return null");
        }
        return staticPathReferenceProvider;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.createReferences must not be null");
        }
        PsiReference[] psiReferenceArray = this.createReferences(psiElement, soft, endingSlashNotAllowed, relativePathsAllowed, (FileType[])null, additionalProviders);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReferenceManagerImpl.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, FileType[] suitableFileTypes, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.createReferences must not be null");
        }
        ArrayList<PsiReference> mergedReferences = new ArrayList<PsiReference>();
        PathReferenceManagerImpl.processProvider(psiElement, this.myGlobalPathsProvider, mergedReferences, soft);
        StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(suitableFileTypes);
        staticProvider.setEndingSlashNotAllowed(endingSlashNotAllowed);
        staticProvider.setRelativePathsAllowed(relativePathsAllowed);
        PathReferenceManagerImpl.processProvider(psiElement, staticProvider, mergedReferences, soft);
        for (PathReferenceProvider provider : PathReferenceManagerImpl.getProviders()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        for (PathReferenceProvider provider : additionalProviders) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        for (PathReferenceProvider provider : (PathReferenceProvider[])Extensions.getExtensions((ExtensionPointName)ANCHOR_REFERENCE_PROVIDER_EP)) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        PsiReference[] psiReferenceArray = PathReferenceManagerImpl.mergeReferences(psiElement, mergedReferences);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReferenceManagerImpl.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createCustomReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... providers) {
        PathReferenceProvider provider;
        boolean processed;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.createCustomReferences must not be null");
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        PathReferenceProvider[] arr$ = providers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(processed = PathReferenceManagerImpl.processProvider(psiElement, provider = arr$[i$], references, soft)); ++i$) {
        }
        PsiReference[] psiReferenceArray = PathReferenceManagerImpl.mergeReferences(psiElement, references);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReferenceManagerImpl.createCustomReferences must not return null");
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReferenceManagerImpl.createReferences must not be null");
        }
        PsiReference[] psiReferenceArray = this.createReferences(psiElement, soft, false, true, (FileType[])null, additionalProviders);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReferenceManagerImpl.createReferences must not return null");
        }
        return psiReferenceArray;
    }

    private static PsiReference[] mergeReferences(PsiElement element, List<PsiReference> references) {
        if (references.size() <= 1) {
            return references.toArray(new PsiReference[references.size()]);
        }
        Collections.sort(references, START_OFFSET_COMPARATOR);
        ArrayList<PsiReference> intersecting = new ArrayList<PsiReference>();
        ArrayList<PsiReference> notIntersecting = new ArrayList<PsiReference>();
        TextRange intersectingRange = references.get(0).getRangeInElement();
        boolean intersected = false;
        for (int i = 1; i < references.size(); ++i) {
            PsiReference reference = references.get(i);
            TextRange range = reference.getRangeInElement();
            int offset = range.getStartOffset();
            if (intersectingRange.getStartOffset() <= offset && intersectingRange.getEndOffset() >= offset) {
                intersected = true;
                intersecting.add(references.get(i - 1));
                if (i == references.size() - 1) {
                    intersecting.add(reference);
                }
                intersectingRange = intersectingRange.union(range);
                continue;
            }
            if (intersected) {
                intersecting.add(references.get(i - 1));
                intersected = false;
            } else {
                notIntersecting.add(references.get(i - 1));
            }
            intersectingRange = range;
            if (i != references.size() - 1) continue;
            notIntersecting.add(reference);
        }
        List<PsiReference> result = PathReferenceManagerImpl.doMerge(element, intersecting);
        result.addAll(notIntersecting);
        return result.toArray(new PsiReference[result.size()]);
    }

    private static List<PsiReference> doMerge(PsiElement element, List<PsiReference> references) {
        TextRange range;
        SmartList list;
        ArrayList<PsiReference> resolvingRefs = new ArrayList<PsiReference>();
        ArrayList<PsiReference> nonResolvingRefs = new ArrayList<PsiReference>();
        for (int i = 0; i < references.size(); ++i) {
            PsiReference reference = references.get(i);
            assert (element.equals(reference.getElement()));
            if (reference.resolve() != null) {
                resolvingRefs.add(reference);
                continue;
            }
            nonResolvingRefs.add(reference);
        }
        ArrayList<PsiReference> result = new ArrayList<PsiReference>(5);
        while (!resolvingRefs.isEmpty()) {
            list = new ArrayList(5);
            range = PathReferenceManagerImpl.getFirstIntersectingReferences(resolvingRefs, (List<PsiReference>)list);
            TextRange textRange = PathReferenceManagerImpl.addIntersectingReferences(nonResolvingRefs, (List<PsiReference>)list, range);
            PathReferenceManagerImpl.addToResult(element, result, (List<PsiReference>)list, textRange);
        }
        while (!nonResolvingRefs.isEmpty()) {
            list = new SmartList();
            range = PathReferenceManagerImpl.getFirstIntersectingReferences(nonResolvingRefs, (List<PsiReference>)list);
            int endOffset = range.getEndOffset();
            for (PsiReference reference : list) {
                endOffset = Math.min(endOffset, reference.getRangeInElement().getEndOffset());
            }
            PathReferenceManagerImpl.addToResult(element, result, (List<PsiReference>)list, new TextRange(range.getStartOffset(), endOffset));
        }
        return result;
    }

    private static void addToResult(PsiElement element, List<PsiReference> result, List<PsiReference> list, TextRange range) {
        if (list.size() == 1) {
            result.add(list.get(0));
        } else {
            PsiDynaReference<PsiElement> psiDynaReference = new PsiDynaReference<PsiElement>(element);
            psiDynaReference.addReferences(list);
            psiDynaReference.setRangeInElement(range);
            result.add((PsiReference)psiDynaReference);
        }
    }

    private static TextRange addIntersectingReferences(List<PsiReference> set, List<PsiReference> toAdd, TextRange range) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getStartOffset();
        Iterator<PsiReference> iterator = set.iterator();
        while (iterator.hasNext()) {
            PsiReference reference = iterator.next();
            TextRange rangeInElement = reference.getRangeInElement();
            if (!PathReferenceManagerImpl.intersect(range, rangeInElement)) continue;
            toAdd.add(reference);
            iterator.remove();
            startOffset = Math.min(startOffset, rangeInElement.getStartOffset());
            endOffset = Math.max(endOffset, rangeInElement.getEndOffset());
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean intersect(TextRange range1, TextRange range2) {
        return range2.intersectsStrict(range1) || range2.intersects(range1) && (range1.isEmpty() || range2.isEmpty());
    }

    private static TextRange getFirstIntersectingReferences(List<PsiReference> set, List<PsiReference> toAdd) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        Iterator<PsiReference> it = set.iterator();
        while (it.hasNext()) {
            PsiReference reference = it.next();
            TextRange range = reference.getRangeInElement();
            if (endOffset != -1 && range.getStartOffset() > endOffset) break;
            startOffset = Math.min(startOffset, range.getStartOffset());
            endOffset = Math.max(range.getEndOffset(), endOffset);
            toAdd.add(reference);
            it.remove();
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean processProvider(PsiElement psiElement, PathReferenceProvider provider, List<PsiReference> mergedReferences, boolean soft) {
        return provider.createReferences(psiElement, mergedReferences, soft);
    }

    private static PathReferenceProvider[] getProviders() {
        return (PathReferenceProvider[])Extensions.getExtensions((ExtensionPointName)PATH_REFERENCE_PROVIDER_EP);
    }
}

