/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public final class IdeMouseEventDispatcher {
    private final PresentationFactory myPresentationFactory;
    private final ArrayList<AnAction> myActions;
    private final Map<Container, Integer> myRootPane2BlockedId = new HashMap();

    public IdeMouseEventDispatcher() {
        this.myPresentationFactory = new PresentationFactory();
        this.myActions = new ArrayList(1);
    }

    private void fillActionsList(Component component, MouseShortcut shortcut, boolean isModalContext) {
        KeymapManager keymapManager;
        ArrayList listOfActions;
        this.myActions.clear();
        if (component instanceof JComponent && (listOfActions = (ArrayList)((JComponent)component).getClientProperty("AnAction.shortcutSet")) != null) {
            for (AnAction action : listOfActions) {
                Shortcut[] shortcuts = action.getShortcutSet().getShortcuts();
                for (String string : shortcuts) {
                    if (!shortcut.equals((Object)string) || this.myActions.contains(action)) continue;
                    this.myActions.add(action);
                }
            }
            if (!this.myActions.isEmpty()) {
                return;
            }
        }
        if (KeymapManagerImpl.ourKeymapManagerInitialized && (keymapManager = KeymapManager.getInstance()) != null) {
            Keymap keymap = keymapManager.getActiveKeymap();
            String[] actionIds = keymap.getActionIds(shortcut);
            ActionManager actionManager = ActionManager.getInstance();
            for (String string : actionIds) {
                AnAction action = actionManager.getAction(string);
                if (action == null || isModalContext && !action.isEnabledInModalContext() || this.myActions.contains(action)) continue;
                this.myActions.add(action);
            }
        }
    }

    public boolean dispatchMouseEvent(MouseEvent e) {
        Integer lastId;
        JRootPane root;
        boolean toIgnore = false;
        if (e.getID() != 501 && e.getID() != 502 && e.getID() != 500) {
            toIgnore = true;
        }
        if (e.isConsumed() || e.isPopupTrigger() || 502 != e.getID() || e.getClickCount() < 1 || e.getButton() == 0) {
            toIgnore = true;
        }
        if ((root = this.findRoot(e)) != null && (lastId = this.myRootPane2BlockedId.get(root)) != null) {
            if (e.getID() <= lastId) {
                this.myRootPane2BlockedId.remove(root);
            } else {
                this.myRootPane2BlockedId.put(root, e.getID());
                return true;
            }
        }
        if (toIgnore) {
            return false;
        }
        Component component = e.getComponent();
        if (component == null) {
            throw new IllegalStateException("component cannot be null");
        }
        if ((component = SwingUtilities.getDeepestComponentAt(component, e.getX(), e.getY())) instanceof IdeGlassPaneImpl) {
            component = ((IdeGlassPaneImpl)component).getTargetComponentFor(e);
        }
        if (component == null) {
            return false;
        }
        if (!KeymapManagerImpl.ourKeymapManagerInitialized) {
            return false;
        }
        MouseShortcut shortcut = new MouseShortcut(e.getButton(), e.getModifiersEx(), e.getClickCount());
        this.fillActionsList(component, shortcut, IdeKeyEventDispatcher.isModalContext(component));
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (actionManager != null) {
            for (int i = 0; i < this.myActions.size(); ++i) {
                AnAction action = this.myActions.get(i);
                DataContext dataContext = DataManager.getInstance().getDataContext(component);
                Presentation presentation = this.myPresentationFactory.getPresentation(action);
                AnActionEvent actionEvent = new AnActionEvent((InputEvent)e, dataContext, "MainMenu", presentation, ActionManager.getInstance(), e.getModifiers());
                action.beforeActionPerformedUpdate(actionEvent);
                if (!presentation.isEnabled()) continue;
                actionManager.fireBeforeActionPerformed(action, dataContext, actionEvent);
                Component c = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                if (c != null && !c.isShowing()) continue;
                action.actionPerformed(actionEvent);
                e.consume();
            }
        }
        return false;
    }

    public void blockNextEvents(MouseEvent e) {
        JRootPane root = this.findRoot(e);
        if (root == null) {
            return;
        }
        this.myRootPane2BlockedId.put(root, e.getID());
    }

    private JRootPane findRoot(MouseEvent e) {
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        JRootPane root = null;
        if (parent instanceof JWindow) {
            root = ((JWindow)parent).getRootPane();
        } else if (parent instanceof JDialog) {
            root = ((JDialog)parent).getRootPane();
        } else if (parent instanceof JFrame) {
            root = ((JFrame)parent).getRootPane();
        }
        return root;
    }
}

