/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileDrop;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TitlePanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserDialogImpl
extends DialogWrapper
implements FileChooserDialog,
FileLookup {
    public static final DataKey<Boolean> PREFER_LAST_OVER_TO_SELECT = DataKey.create((String)"PREFER_LAST_OVER_TO_SELECT");
    private final FileChooserDescriptor myChooserDescriptor;
    protected FileSystemTreeImpl myFileSystemTree;
    private static VirtualFile ourLastFile;
    private Project myProject;
    private VirtualFile[] myChosenFiles = VirtualFile.EMPTY_ARRAY;
    private JPanel myNorthPanel;
    private static boolean ourToShowTextField;
    private TextFieldAction myTextFieldAction;
    protected FileTextFieldImpl myPathTextField;
    private JComponent myPathTextFieldWrapper;
    private MergingUpdateQueue myUiUpdater;
    private boolean myTreeIsUpdating;
    public static DataKey<FileChooserDialogImpl> KEY;
    private final Map<String, LocalFileSystem.WatchRequest> myRequests = new HashMap();

    public FileChooserDialogImpl(FileChooserDescriptor chooserDescriptor, Project project) {
        super(project, true);
        this.myProject = project;
        this.myChooserDescriptor = chooserDescriptor;
        this.setTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
    }

    public FileChooserDialogImpl(FileChooserDescriptor chooserDescriptor, Component parent) {
        super(parent, true);
        this.myChooserDescriptor = chooserDescriptor;
        this.setTitle(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
    }

    @NotNull
    public VirtualFile[] choose(VirtualFile toSelect, Project project) {
        VirtualFile file;
        this.init();
        VirtualFile selectFile = null;
        if (toSelect == null && ourLastFile == null) {
            if (project != null && project.getBaseDir() != null) {
                selectFile = project.getBaseDir();
            }
        } else {
            VirtualFile virtualFile = toSelect == null ? ourLastFile : (ourLastFile == null ? toSelect : (selectFile = this.myChooserDescriptor.getUserData(PREFER_LAST_OVER_TO_SELECT.getName()) == null ? toSelect : ourLastFile));
        }
        if ((file = selectFile) != null && file.isValid()) {
            this.myFileSystemTree.select(file, new Runnable(){

                @Override
                public void run() {
                    if (!file.equals(FileChooserDialogImpl.this.myFileSystemTree.getSelectedFile())) {
                        VirtualFile parent = file.getParent();
                        if (parent != null) {
                            FileChooserDialogImpl.this.myFileSystemTree.select(parent, null);
                        }
                    } else if (file.isDirectory()) {
                        FileChooserDialogImpl.this.myFileSystemTree.expand(file);
                    }
                }
            });
        }
        this.show();
        if (this.myChosenFiles == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileChooser/ex/FileChooserDialogImpl.choose must not return null");
        }
        return this.myChosenFiles;
    }

    protected DefaultActionGroup createActionGroup() {
        this.registerFileChooserShortcut("$Delete", "FileChooser.Delete");
        this.registerFileChooserShortcut("Synchronize", "FileChooser.Refresh");
        return (DefaultActionGroup)ActionManager.getInstance().getAction("FileChooserToolbar");
    }

    private void registerFileChooserShortcut(@NonNls String baseActionId, @NonNls String fileChooserActionId) {
        JTree tree = this.myFileSystemTree.getTree();
        AnAction syncAction = ActionManager.getInstance().getAction(fileChooserActionId);
        AnAction original = ActionManager.getInstance().getAction(baseActionId);
        syncAction.registerCustomShortcutSet(original.getShortcutSet(), (JComponent)tree, this.myDisposable);
    }

    @Nullable
    protected final JComponent createTitlePane() {
        String title = this.myChooserDescriptor.getTitle();
        String description = this.myChooserDescriptor.getDescription();
        if ((StringUtil.isEmptyOrSpaces((String)title) || title.equals(UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]))) && StringUtil.isEmptyOrSpaces((String)description)) {
            return null;
        }
        return new TitlePanel(title, description);
    }

    protected JComponent createCenterPanel() {
        MyPanel panel = new MyPanel();
        this.myUiUpdater = new MergingUpdateQueue("FileChooserUpdater", 200, false, (JComponent)panel);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUiUpdater);
        new UiNotifyConnector((Component)panel, (Activatable)this.myUiUpdater);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createTree();
        DefaultActionGroup group = this.createActionGroup();
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolBar.getComponent(), "Center");
        this.myTextFieldAction = new TextFieldAction();
        toolbarPanel.add((Component)((Object)this.myTextFieldAction), "East");
        this.myPathTextFieldWrapper = new JPanel(new BorderLayout());
        this.myPathTextFieldWrapper.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.myPathTextField = new FileTextFieldImpl.Vfs(this.myChooserDescriptor, this.myFileSystemTree.areHiddensShown(), FileChooserFactoryImpl.getMacroMap(), this.getDisposable()){

            @Override
            protected void onTextChanged(String newValue) {
                FileChooserDialogImpl.this.updateTreeFromPath(newValue);
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPathTextField);
        this.myPathTextFieldWrapper.add((Component)this.myPathTextField.getField(), "Center");
        this.myNorthPanel = new JPanel(new BorderLayout());
        this.myNorthPanel.add((Component)toolbarPanel, "North");
        this.updateTextFieldShowing();
        panel.add((Component)this.myNorthPanel, "North");
        this.registerMouseListener((ActionGroup)group);
        JScrollPane scrollPane = new JScrollPane(this.myFileSystemTree.getTree());
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(400, 400));
        panel.add((Component)new JLabel("<html><center><small><font color=gray>Drag and drop a file into the space above to quickly locate it in the tree.</font></small></center></html>", 0), "South");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        if (ourToShowTextField) {
            return this.myPathTextField != null ? this.myPathTextField.getField() : null;
        }
        return this.myFileSystemTree != null ? this.myFileSystemTree.getTree() : null;
    }

    public final void dispose() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRequests.values());
        super.dispose();
    }

    private boolean isTextFieldActive() {
        return this.myPathTextField.getField().getRootPane() != null;
    }

    protected void doOKAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        if (this.isTextFieldActive()) {
            String text = this.myPathTextField.getTextFieldText();
            FileLookup.LookupFile file = this.myPathTextField.getFile();
            if (text == null || file == null || !file.exists()) {
                this.setErrorText("Specified path cannot be found");
                return;
            }
        }
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        try {
            this.myChooserDescriptor.validateSelectedFiles(selectedFiles);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
            return;
        }
        this.myChosenFiles = selectedFiles;
        if (selectedFiles.length == 0) {
            this.close(1);
            return;
        }
        ourLastFile = selectedFiles[selectedFiles.length - 1];
        super.doOKAction();
    }

    public final void doCancelAction() {
        this.myChosenFiles = VirtualFile.EMPTY_ARRAY;
        super.doCancelAction();
    }

    protected JTree createTree() {
        this.myFileSystemTree = new FileSystemTreeImpl(this.myProject, this.myChooserDescriptor);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myFileSystemTree);
        this.myFileSystemTree.addOkAction(new Runnable(){

            @Override
            public void run() {
                FileChooserDialogImpl.this.doOKAction();
            }
        });
        JTree tree = this.myFileSystemTree.getTree();
        tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        tree.addTreeSelectionListener(new FileTreeSelectionListener());
        tree.addTreeExpansionListener(new FileTreeExpansionListener());
        this.setOKActionEnabled(false);
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(List<VirtualFile> selection) {
                FileChooserDialogImpl.this.updatePathFromTree(selection, false);
            }
        }, this.myDisposable);
        new FileDrop(tree, new FileDrop.Target(){

            @Override
            public FileChooserDescriptor getDescriptor() {
                return FileChooserDialogImpl.this.myChooserDescriptor;
            }

            @Override
            public boolean isHiddenShown() {
                return FileChooserDialogImpl.this.myFileSystemTree.areHiddensShown();
            }

            @Override
            public void dropFiles(List<VirtualFile> files) {
                if (!FileChooserDialogImpl.this.myChooserDescriptor.isChooseMultiple() && files.size() > 0) {
                    FileChooserDialogImpl.this.selectInTree(new VirtualFile[]{files.get(0)}, true);
                } else {
                    FileChooserDialogImpl.this.selectInTree(VfsUtil.toVirtualFileArray(files), true);
                }
            }
        });
        return tree;
    }

    protected final void registerMouseListener(ActionGroup group) {
        this.myFileSystemTree.registerMouseListener(group);
    }

    protected VirtualFile[] getSelectedFiles() {
        return this.myFileSystemTree.getChoosenFiles();
    }

    public void toggleShowTextField() {
        ourToShowTextField = !ourToShowTextField;
        this.updateTextFieldShowing();
    }

    private void updateTextFieldShowing() {
        this.myTextFieldAction.update();
        this.myNorthPanel.remove(this.myPathTextFieldWrapper);
        if (ourToShowTextField) {
            if (this.myFileSystemTree.getSelectedFile() != null) {
                ArrayList<VirtualFile> selection = new ArrayList<VirtualFile>();
                selection.add(this.myFileSystemTree.getSelectedFile());
                this.updatePathFromTree(selection, true);
            }
            this.myNorthPanel.add((Component)this.myPathTextFieldWrapper, "Center");
        } else {
            this.setErrorText(null);
        }
        this.myPathTextField.getField().requestFocus();
        this.myNorthPanel.revalidate();
        this.myNorthPanel.repaint();
    }

    private void updatePathFromTree(List<VirtualFile> selection, boolean now) {
        if (!ourToShowTextField || this.myTreeIsUpdating) {
            return;
        }
        String text = "";
        if (selection.size() > 0) {
            VirtualFile vFile = selection.get(0);
            text = vFile.isInLocalFileSystem() ? vFile.getPresentableUrl() : vFile.getUrl();
        }
        this.myPathTextField.setText(text, now, new Runnable(){

            @Override
            public void run() {
                FileChooserDialogImpl.this.myPathTextField.getField().selectAll();
                FileChooserDialogImpl.this.setErrorText(null);
            }
        });
    }

    private void updateTreeFromPath(final String text) {
        if (!ourToShowTextField) {
            return;
        }
        if (this.myPathTextField.isPathUpdating()) {
            return;
        }
        if (text == null) {
            return;
        }
        this.myUiUpdater.queue(new Update("treeFromPath.1"){

            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        final LocalFsFinder.VfsFile toFind = (LocalFsFinder.VfsFile)FileChooserDialogImpl.this.myPathTextField.getFile();
                        if (toFind == null || !toFind.exists()) {
                            return;
                        }
                        FileChooserDialogImpl.this.myUiUpdater.queue(new Update("treeFromPath.2"){

                            public void run() {
                                FileChooserDialogImpl.this.selectInTree(toFind.getFile(), text);
                            }
                        });
                    }
                });
            }
        });
    }

    private void selectInTree(VirtualFile vFile, String fromText) {
        if (vFile != null && vFile.isValid()) {
            if (fromText == null || fromText.equalsIgnoreCase(this.myPathTextField.getTextFieldText())) {
                this.selectInTree(new VirtualFile[]{vFile}, false);
            }
        } else {
            this.reportFileNotFound();
        }
    }

    private void selectInTree(VirtualFile[] vFile, final boolean requestFocus) {
        this.myTreeIsUpdating = true;
        if (!Arrays.asList(this.myFileSystemTree.getSelectedFiles()).contains(vFile)) {
            this.myFileSystemTree.select(vFile, new Runnable(){

                @Override
                public void run() {
                    FileChooserDialogImpl.this.myTreeIsUpdating = false;
                    FileChooserDialogImpl.this.setErrorText(null);
                    if (requestFocus) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FileChooserDialogImpl.this.myFileSystemTree.getTree().requestFocus();
                            }
                        });
                    }
                }
            });
        } else {
            this.myTreeIsUpdating = false;
            this.setErrorText(null);
        }
    }

    private void reportFileNotFound() {
        this.myTreeIsUpdating = false;
        this.setErrorText(null);
    }

    protected String getDimensionServiceKey() {
        return "FileChooserDialogImpl";
    }

    static {
        ourToShowTextField = true;
        KEY = DataKey.create((String)"FileChooserDialog");
    }

    private class TextFieldAction
    extends LinkLabel
    implements LinkListener {
        public TextFieldAction() {
            super("", null);
            this.setListener(this, null);
            this.update();
        }

        protected void onSetActive(boolean active) {
            String tooltip = AnAction.createTooltipText((String)ActionsBundle.message((String)"action.FileChooser.TogglePathShowing.text", (Object[])new Object[0]), (AnAction)ActionManager.getInstance().getAction("FileChooser.TogglePathShowing"));
            this.setToolTipText(tooltip);
        }

        protected String getStatusBarText() {
            return ActionsBundle.message((String)"action.FileChooser.TogglePathShowing.text", (Object[])new Object[0]);
        }

        public void update() {
            this.setVisible(true);
            this.setText(ourToShowTextField ? IdeBundle.message((String)"file.chooser.hide.path", (Object[])new Object[0]) : IdeBundle.message((String)"file.chooser.show.path", (Object[])new Object[0]));
        }

        public void linkSelected(LinkLabel aSource, Object aLinkData) {
            FileChooserDialogImpl.this.toggleShowTextField();
        }
    }

    protected final class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout(0, 0));
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return FileChooserDialogImpl.this.getSelectedFiles();
            }
            if (KEY.is(dataId)) {
                return FileChooserDialogImpl.this;
            }
            if (FileSystemTree.DATA_KEY.is(dataId)) {
                return FileChooserDialogImpl.this.myFileSystemTree;
            }
            return FileChooserDialogImpl.this.myChooserDescriptor.getUserData(dataId);
        }
    }

    private final class FileTreeSelectionListener
    implements TreeSelectionListener {
        private FileTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = e.getPaths();
            boolean enabled = true;
            for (TreePath treePath : paths) {
                if (!e.isAddedPath(treePath)) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!(userObject instanceof FileNodeDescriptor)) {
                    enabled = false;
                    break;
                }
                FileElement descriptor = ((FileNodeDescriptor)((Object)userObject)).getElement();
                VirtualFile file = descriptor.getFile();
                enabled = file != null && FileChooserDialogImpl.this.myChooserDescriptor.isFileSelectable(file);
            }
            FileChooserDialogImpl.this.setOKActionEnabled(enabled);
        }
    }

    private final class FileTreeExpansionListener
    implements TreeExpansionListener {
        private FileTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            VirtualFile file;
            DefaultMutableTreeNode node;
            Object userObject;
            Object[] path = event.getPath().getPath();
            if (path.length == 2 && (userObject = (node = (DefaultMutableTreeNode)path[1]).getUserObject()) instanceof FileNodeDescriptor && (file = ((FileNodeDescriptor)((Object)userObject)).getElement().getFile()) != null && file.isDirectory()) {
                String rootPath = file.getPath();
                if (FileChooserDialogImpl.this.myRequests.get(rootPath) == null) {
                    LocalFileSystem.WatchRequest watchRequest = LocalFileSystem.getInstance().addRootToWatch(rootPath, true);
                    FileChooserDialogImpl.this.myRequests.put(rootPath, watchRequest);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

