/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VisibleEditorsTracker
extends CommandAdapter
implements ApplicationComponent {
    private final Set<Editor> myEditorsVisibleOnCommandStart = new HashSet<Editor>();
    private long myCurrentCommandStart;
    private long myLastCommandFinish;

    public static VisibleEditorsTracker getInstance() {
        return (VisibleEditorsTracker)((Object)ApplicationManager.getApplication().getComponent(VisibleEditorsTracker.class));
    }

    public VisibleEditorsTracker(CommandProcessor commandProcessor) {
        commandProcessor.addCommandListener((CommandListener)this);
    }

    @NotNull
    public String getComponentName() {
        if ("VisibleEditorsTracker" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/VisibleEditorsTracker.getComponentName must not return null");
        }
        return "VisibleEditorsTracker";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public boolean wasEditorVisibleOnCommandStart(Editor editor) {
        return this.myEditorsVisibleOnCommandStart.contains(editor);
    }

    public long getCurrentCommandStart() {
        return this.myCurrentCommandStart;
    }

    public long getLastCommandFinish() {
        return this.myLastCommandFinish;
    }

    public void commandStarted(CommandEvent event) {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.getComponent().isShowing()) {
                this.myEditorsVisibleOnCommandStart.add(editor);
            }
            ((ScrollingModelImpl)editor.getScrollingModel()).commandStarted();
            this.myCurrentCommandStart = System.currentTimeMillis();
        }
    }

    public void commandFinished(CommandEvent event) {
        this.myEditorsVisibleOnCommandStart.clear();
        this.myLastCommandFinish = System.currentTimeMillis();
    }
}

