/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.lang.ref.SoftReference;

abstract class CharArray
implements CharSequenceBackedByArray {
    private int myCount = 0;
    private CharSequence myOriginalSequence;
    private char[] myArray = null;
    private SoftReference<String> myStringRef = null;
    private int myBufferSize;

    CharArray(int bufferSize) {
        this.myBufferSize = bufferSize;
        this.myOriginalSequence = "";
    }

    public void setBufferSize(int bufferSize) {
        this.myBufferSize = bufferSize;
    }

    protected abstract DocumentEvent beforeChangedUpdate(int var1, CharSequence var2, CharSequence var3, boolean var4);

    protected abstract void afterChangedUpdate(DocumentEvent var1, long var2);

    public void setText(CharSequence chars) {
        this.myOriginalSequence = chars;
        this.myArray = null;
        this.myCount = chars.length();
        this.myStringRef = null;
        this.trimToSize();
    }

    public void replace(int startOffset, int endOffset, CharSequence toDelete, CharSequence newString, long newModificationStamp, boolean wholeTextReplaced) {
        DocumentEvent event = this.beforeChangedUpdate(startOffset, toDelete, newString, wholeTextReplaced);
        this.doReplace(startOffset, endOffset, newString);
        this.afterChangedUpdate(event, newModificationStamp);
    }

    private void doReplace(int startOffset, int endOffset, CharSequence newString) {
        this.prepareForModification();
        int newLength = newString.length();
        int oldLength = endOffset - startOffset;
        CharArrayUtil.getChars((CharSequence)newString, (char[])this.myArray, (int)startOffset, (int)Math.min(newLength, oldLength));
        if (newLength > oldLength) {
            this.doInsert(newString.subSequence(oldLength, newLength), endOffset);
        } else if (newLength < oldLength) {
            this.doRemove(startOffset + newLength, startOffset + oldLength);
        }
    }

    public void remove(int startIndex, int endIndex, CharSequence toDelete) {
        DocumentEvent event = this.beforeChangedUpdate(startIndex, toDelete, null, false);
        this.doRemove(startIndex, endIndex);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
    }

    private void doRemove(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        this.prepareForModification();
        if (endIndex < this.myCount) {
            System.arraycopy(this.myArray, endIndex, this.myArray, startIndex, this.myCount - endIndex);
        }
        this.myCount -= endIndex - startIndex;
    }

    public void insert(CharSequence s, int startIndex) {
        DocumentEvent event = this.beforeChangedUpdate(startIndex, null, s, false);
        this.doInsert(s, startIndex);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
        this.trimToSize();
    }

    private void doInsert(CharSequence s, int startIndex) {
        this.prepareForModification();
        int insertLength = s.length();
        this.myArray = CharArray.relocateArray(this.myArray, this.myCount + insertLength);
        if (startIndex < this.myCount) {
            System.arraycopy(this.myArray, startIndex, this.myArray, startIndex + insertLength, this.myCount - startIndex);
        }
        CharArrayUtil.getChars((CharSequence)s, (char[])this.myArray, (int)startIndex);
        this.myCount += insertLength;
    }

    private void prepareForModification() {
        if (this.myOriginalSequence != null) {
            this.myArray = new char[this.myOriginalSequence.length()];
            CharArrayUtil.getChars((CharSequence)this.myOriginalSequence, (char[])this.myArray, (int)0);
            this.myOriginalSequence = null;
        }
        this.myStringRef = null;
    }

    public CharSequence getCharArray() {
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence;
        }
        return this;
    }

    public String toString() {
        String str;
        String string = str = this.myStringRef != null ? this.myStringRef.get() : null;
        if (str == null) {
            str = this.myOriginalSequence != null ? ((Object)this.myOriginalSequence).toString() : new String(this.myArray, 0, this.myCount);
            this.myStringRef = new SoftReference<String>(str);
        }
        return str;
    }

    public final int length() {
        return this.myCount;
    }

    public final char charAt(int i) {
        if (i < 0 || i >= this.myCount) {
            throw new IndexOutOfBoundsException("Wrong offset: " + i + "; count:" + this.myCount);
        }
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence.charAt(i);
        }
        return this.myArray[i];
    }

    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.myCount) {
            return this;
        }
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence.subSequence(start, end);
        }
        return new CharArrayCharSequence(this.myArray, start, end);
    }

    public char[] getChars() {
        if (this.myOriginalSequence != null && this.myArray == null) {
            this.myArray = CharArrayUtil.fromSequence((CharSequence)this.myOriginalSequence);
        }
        return this.myArray;
    }

    public void getChars(char[] dst, int dstOffset) {
        if (this.myOriginalSequence != null) {
            CharArrayUtil.getChars((CharSequence)this.myOriginalSequence, (char[])dst, (int)dstOffset);
        } else {
            System.arraycopy(this.myArray, 0, dst, dstOffset, this.length());
        }
    }

    public CharSequence substring(int start, int end) {
        if (start == end) {
            return "";
        }
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence.subSequence(start, end);
        }
        return new String(this.myArray, start, end - start);
    }

    private static char[] relocateArray(char[] array, int index) {
        if (index < array.length) {
            return array;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 12 / 10 + 1;
        }
        char[] newArray = new char[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.myCount > this.myBufferSize) {
            this.remove(0, this.myCount - this.myBufferSize, ((Object)this.getCharArray().subSequence(0, this.myCount - this.myBufferSize)).toString());
        }
    }
}

