/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.util.text.StringUtil;

class PreferWholeLines
implements DiffCorrection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.processing.PreferWholeLines");
    public static final DiffCorrection INSTANCE = new PreferWholeLines();

    PreferWholeLines() {
    }

    public DiffFragment[] correct(DiffFragment[] fragments) {
        for (int i = 1; i < fragments.length - 1; ++i) {
            DiffFragment fragment = fragments[i];
            if (!fragment.isOneSide()) continue;
            DiffFragment nextFragment = fragments[i + 1];
            FragmentSide side = FragmentSide.chooseSide((DiffFragment)fragment);
            if (nextFragment.isOneSide()) {
                LOG.error("<" + side.getText(fragment) + "> <" + side.getOtherText(nextFragment) + ">");
            }
            if (!StringUtil.startsWithChar((CharSequence)side.getText(fragment), (char)'\n') || !StringUtil.startsWithChar((CharSequence)side.getText(nextFragment), (char)'\n') || !StringUtil.startsWithChar((CharSequence)side.getOtherText(nextFragment), (char)'\n')) continue;
            DiffFragment previous = fragments[i - 1];
            fragments[i - 1] = previous = side.createFragment(side.getText(previous) + "\n", side.getOtherText(previous) + "\n", previous.isModified());
            fragments[i] = fragment = side.createFragment(side.getText(fragment).substring(1) + "\n", side.getOtherText(fragment), fragment.isModified());
            fragments[i + 1] = nextFragment = side.createFragment(side.getText(nextFragment).substring(1), side.getOtherText(nextFragment).substring(1), nextFragment.isModified());
        }
        return fragments;
    }
}

