/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class ApplyNonConflicts
extends AnAction
implements DumbAware {
    public ApplyNonConflicts() {
        super(DiffBundle.message((String)"merge.dialog.apply.all.non.conflicting.changes.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/diff/applyNotConflicts.png"));
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        ArrayList notConflicts = ContainerUtil.collect(ApplyNonConflicts.getNotConflicts(dataContext));
        for (Change change : notConflicts) {
            Change.apply(change, MergeList.BRANCH_SIDE);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(ApplyNonConflicts.getNotConflicts(e.getDataContext()).hasNext());
    }

    private static Iterator<Change> getNotConflicts(DataContext dataContext) {
        MergeList mergeList = MergeList.fromDataContext(dataContext);
        if (mergeList == null) {
            return new ArrayList(1).iterator();
        }
        return FilteringIterator.create(mergeList.getAllChanges(), MergeList.NOT_CONFLICTS);
    }
}

